---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-UnsupportedSchedule

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 766-784行目（formatSchedule関数）
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 767行目（strings.Contains判定）
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 769行目（Eventf呼び出し）
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 97行目（EventSource）
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` 519行目（syncCronJobからの呼び出し）
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 399行目（updateCronJobからの呼び出し、recorder=nil）
- E-07: `pkg/controller/cronjob/cronjob_controllerv2.go` 768行目（recorder != nil判定）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 104行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スケジュール式に"TZ"が含まれる場合にイベント発行 | E-02, E-03 | ○ |
| C-02 | EventTypeはWarning | E-03 | ○ |
| C-03 | Reasonは"UnsupportedSchedule" | E-03 | ○ |
| C-04 | 発行元は"cronjob-controller" | E-04 | ○ |
| C-05 | メッセージにスケジュール式とドキュメントURLが含まれる | E-03 | ○ |
| C-06 | syncCronJobからrecorder付きで呼ばれる | E-05 | ○ |
| C-07 | updateCronJobからはrecorder=nilで呼ばれイベント発行されない | E-06 | ○ |
| C-08 | recorderがnilの場合はイベント発行されない | E-07 | ○ |
| C-09 | CRON_TZ/TZ式はcron/v3ライブラリで解析される | E-01 | ○ |
| C-10 | spec.timeZoneフィールドの使用が推奨される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] formatSchedule関数のロジックが最新コードと一致するか確認
- [ ] ドキュメントURLが最新か確認
