---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-TaintManagerEviction

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/tainteviction/taint_eviction.go` 590-601行目（emitPodDeletionEvent関数）
- E-02: `pkg/controller/tainteviction/taint_eviction.go` 603-614行目（emitCancelPodDeletionEvent関数）
- E-03: `pkg/controller/tainteviction/taint_eviction.go` 600行目（Eventf "Marking for deletion"）
- E-04: `pkg/controller/tainteviction/taint_eviction.go` 613行目（Eventf "Cancelling deletion"）
- E-05: `pkg/controller/tainteviction/taint_eviction.go` 189行目（EventSource）
- E-06: `pkg/controller/tainteviction/taint_eviction.go` 107-127行目（deletePodHandler関数）
- E-07: `pkg/controller/tainteviction/taint_eviction.go` 129-148行目（addConditionAndDeletePod関数）
- E-08: `pkg/controller/tainteviction/taint_eviction.go` 59行目（retries = 5）
- E-09: `pkg/controller/tainteviction/taint_eviction.go` 57行目（UpdateWorkerSize = 8）
- E-10: `pkg/controller/tainteviction/taint_eviction.go` 451-490行目（processPodOnNode関数）
- E-11: `pkg/controller/tainteviction/taint_eviction.go` 533-588行目（handleNodeUpdate関数）
- E-12: `pkg/controller/tainteviction/taint_eviction.go` 357-386行目（worker関数）
- E-13: `pkg/controller/tainteviction/taint_eviction.go` 445-449行目（cancelWorkWithEvent関数）
- E-14: `docs/code-to-docs/通知一覧/通知一覧.csv` 111行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pod削除マーク時に"Marking for deletion"イベント発行 | E-01, E-03 | ○ |
| C-02 | 削除キャンセル時に"Cancelling deletion"イベント発行 | E-02, E-04 | ○ |
| C-03 | EventTypeはNormal | E-03, E-04 | ○ |
| C-04 | Reasonは"TaintManagerEviction" | E-03, E-04 | ○ |
| C-05 | 発行元は"taint-eviction controller" | E-05 | ○ |
| C-06 | Pod削除は最大5回リトライ | E-06, E-08 | ○ |
| C-07 | Pod削除前にDisruptionTarget条件が追加される | E-07 | ○ |
| C-08 | UpdateWorkerSizeは8 | E-09 | ○ |
| C-09 | ノード更新がPod更新より優先される | E-12 | ○ |
| C-10 | GetMatchingTolerationsでToleration判定 | E-10 | ○ |
| C-11 | allTolerated=falseの場合即座に削除スケジュール | E-10 | ○ |
| C-12 | cancelWorkWithEventで既存削除予定をキャンセル | E-13 | ○ |
| C-13 | recorderがnilの場合はイベント非発行 | E-01, E-02 | ○ |
| C-14 | handleNodeUpdate内で全PodにprocessPodOnNodeが呼ばれる | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] emitPodDeletionEvent/emitCancelPodDeletionEventのメッセージが最新コードと一致するか確認
- [ ] controllerName（"taint-eviction controller"）が実際の呼び出し元から正しく渡されるか確認
- [ ] deletePodHandlerのリトライロジックが最新コードと一致するか確認
