---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-TooManyAddressesToMirror

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/endpointslicemirroring/reconciler.go` 128-129行目（Eventf 呼び出し）
- E-02: `pkg/controller/endpointslicemirroring/reconciler.go` 64-172行目（reconcile 関数全体）
- E-03: `pkg/controller/endpointslicemirroring/reconciler.go` 70行目（addressesSkipped 初期化）
- E-04: `pkg/controller/endpointslicemirroring/reconciler.go` 77-78行目（totalAddresses, totalAddressesAdded）
- E-05: `pkg/controller/endpointslicemirroring/reconciler.go` 84行目（maxEndpointsPerSubset break チェック: Addresses）
- E-06: `pkg/controller/endpointslicemirroring/reconciler.go` 99行目（maxEndpointsPerSubset break チェック: NotReadyAddresses）
- E-07: `pkg/controller/endpointslicemirroring/reconciler.go` 110行目（addressesSkipped 計算）
- E-08: `pkg/controller/endpointslicemirroring/reconciler.go` 126行目（addressesSkipped > numInvalidAddresses 条件）
- E-09: `pkg/controller/endpointslicemirroring/events.go` 29-32行目（TooManyAddressesToMirror 定数）
- E-10: `pkg/controller/endpointslicemirroring/reconciler.go` 115行目（AddressesSkippedPerSync メトリクス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventType は Warning | E-01 (corev1.EventTypeWarning) | ○ |
| C-02 | イベント理由は "TooManyAddressesToMirror" | E-01, E-09 | ○ |
| C-03 | メッセージに上限値とスキップ数を含む | E-01 | ○ |
| C-04 | Endpoints オブジェクトに対して発行 | E-01 (endpoints 引数) | ○ |
| C-05 | addressesSkipped > numInvalidAddresses の場合のみ発行 | E-08 | ○ |
| C-06 | Addresses と NotReadyAddresses の両方が上限チェック対象 | E-05, E-06 | ○ |
| C-07 | totalAddresses は Addresses + NotReadyAddresses の合計 | E-04 (77行目) | ○ |
| C-08 | addressesSkipped = totalAddresses - totalAddressesAdded | E-07 | ○ |
| C-09 | maxEndpointsPerSubset 到達時に break | E-05, E-06 | ○ |
| C-10 | AddressesSkippedPerSync メトリクスに記録 | E-10 | ○ |
| C-11 | ログ出力も行われる | E-02 (127行目: klog.Info) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] maxEndpointsPerSubset のデフォルト値を確認
- [ ] スキップ数の計算が無効 IP と上限超過を正しく区別しているか確認
