---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：121-MultiplePodDisruptionBudgets

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Event APIレート制限の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/disruption/disruption.go` 609-625行目 - getPdbForPod関数
- E-02: `pkg/controller/disruption/disruption.go` 619-622行目 - MultiplePodDisruptionBudgets イベント発行コード
- E-03: `pkg/controller/disruption/disruption.go` 81-120行目 - DisruptionController構造体定義
- E-04: `pkg/controller/disruption/disruption.go` 620行目 - メッセージフォーマット文字列
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 122行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Podが複数のPDBに一致した場合にWarningイベントが発行される | E-02 | ○ |
| C-02 | イベントタイプはWarningである | E-02 (v1.EventTypeWarning) | ○ |
| C-03 | 発行元はdisruption-controller | E-05 | ○ |
| C-04 | getPdbForPod関数内で発行される | E-01 | ○ |
| C-05 | len(pdbs) > 1 が送信条件 | E-02 | ○ |
| C-06 | pdbs[0]が任意に選択される | E-01 (624行目) | ○ |
| C-07 | メッセージにNamespace, PodName, PDBNameが含まれる | E-04 | ○ |
| C-08 | Pod変更イベントがトリガーとなる | E-03 | ○ |
| C-09 | pdbLister経由でPDB一覧を取得する | E-01 (613行目) | ○ |
| C-10 | DisruptionController構造体にrecorderフィールドがある | E-03 (115行目) | ○ |
| C-11 | イベントはPodオブジェクトに対して記録される | E-02 | ○ |
| C-12 | Event APIのレート制限に従う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Event APIのレート制限の具体値はKubernetes Event API側の実装に依存するため、disruption-controllerのコードからは直接確認できない
  - 候補：client-go の EventRecorder実装 / API Serverのレート制限設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] getPdbForPod関数の呼び出し元（Pod変更ハンドラ）の確認
- [ ] pdbs[0]の選択が本当に非決定的かどうかの確認
