---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：123-CalculateExpectedPodCountFailed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **getExpectedScaleの内部エラーケース詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/disruption/disruption.go` 746-750行目 - trySync内のイベント発行コード
- E-02: `pkg/controller/disruption/disruption.go` 818-839行目 - getExpectedPodCount関数
- E-03: `pkg/controller/disruption/disruption.go` 748行目 - イベントメッセージフォーマット
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 124行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getExpectedPodCount失敗時にWarningイベントが発行される | E-01 | ○ |
| C-02 | イベント名はCalculateExpectedPodCountFailed | E-03 | ○ |
| C-03 | PDBオブジェクトに対してイベントが記録される | E-01 (pdb引数) | ○ |
| C-04 | trySync関数内で発行される | E-01 | ○ |
| C-05 | maxUnavailable指定時にgetExpectedScaleが呼ばれる | E-02 (826行目) | ○ |
| C-06 | メッセージにエラー内容が含まれる | E-03 | ○ |
| C-07 | エラー後にtrySync関数がエラーを返却する | E-01 (749行目) | ○ |
| C-08 | GetScaledValueFromIntOrPercentでの変換エラーが原因となりうる | E-02 (831行目) | ○ |
| C-09 | 発行元はdisruption-controller | E-04 | ○ |
| C-10 | getExpectedScaleの内部でscaleNamespacer経由でScale情報を取得する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- getExpectedScale関数の内部実装を直接確認していないため、Scale API呼び出しの詳細は推定である
  - 候補：disruption.go 内の getExpectedScale 関数の全文確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行箇所のコードは明確

## 6) レビュアーチェックリスト（最小）
- [ ] getExpectedScale関数の完全な実装確認
- [ ] minAvailableが整数値の場合にgetExpectedPodCountがエラーを返すケースの確認
