---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：124-UnmanagedPods

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **unmanagedPodsの判定ロジック詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/disruption/disruption.go` 751-758行目 - UnmanagedPodsイベント発行コード
- E-02: `pkg/controller/disruption/disruption.go` 754-757行目 - イベントメッセージフォーマット
- E-03: `pkg/controller/disruption/disruption.go` 818行目 - getExpectedPodCount関数シグネチャ
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 125行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | unmanagedPods検出時にWarningイベントが発行される | E-01 | ○ |
| C-02 | イベント名はUnmanagedPods | E-01 | ○ |
| C-03 | PDBオブジェクトに対してイベントが記録される | E-01 (pdb引数) | ○ |
| C-04 | 処理はエラーではなく続行される | E-01 (751行目のコメント) | ○ |
| C-05 | メッセージにPDBセレクタとminAvailable設定推奨が含まれる | E-02 | ○ |
| C-06 | len(unmanagedPods) > 0 が送信条件 | E-01 (752行目) | ○ |
| C-07 | getExpectedPodCountがunmanagedPodsを返す | E-03 | ○ |
| C-08 | 発行元はdisruption-controller | E-04 | ○ |
| C-09 | trySync関数内で発行される | E-01 | ○ |
| C-10 | unmanagedPodsはownerReferencesに基づいて判定される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- unmanagedPodsの具体的な判定ロジック（getExpectedScale内）を直接確認していない
  - 候補：disruption.go 内の getExpectedScale 関数の全文確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] getExpectedScale内のunmanagedPods判定ロジックの確認
- [ ] minAvailableを整数値に設定した場合の動作確認
