---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：125-NotDeleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **pdb.Namespaceが2回使われている点**：バグの可能性あり、要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/disruption/disruption.go` 944-976行目 - buildDisruptedPodMap関数
- E-02: `pkg/controller/disruption/disruption.go` 966-967行目 - NotDeleted イベント発行コード
- E-03: `pkg/controller/disruption/disruption.go` 59-69行目 - DeletionTimeout定数
- E-04: `pkg/controller/disruption/disruption.go` 962行目 - 予想削除時刻計算
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 126行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DeletionTimeoutは2分 | E-03 | ○ |
| C-02 | buildDisruptedPodMap内で発行される | E-01 | ○ |
| C-03 | DisruptedPodsマップのPodを確認する | E-01 (945, 957行目) | ○ |
| C-04 | DeletionTimestamp設定済みPodはスキップ | E-01 (953行目) | ○ |
| C-05 | 予想削除時刻 = disruptionTime + DeletionTimeout | E-04 | ○ |
| C-06 | 現在時刻を超過した場合にWarningイベント発行 | E-01 (963行目), E-02 | ○ |
| C-07 | Podオブジェクトに対してイベントが記録される | E-02 (pod引数) | ○ |
| C-08 | メッセージにpdb.Namespaceが含まれる | E-02 | ○ |
| C-09 | タイムアウト前のPodはresultに追加される | E-01 (972行目) | ○ |
| C-10 | recheckTimeが更新される | E-01 (969行目) | ○ |
| C-11 | pdb.Namespaceが2回使われている（バグの可能性） | E-02 (967行目) | ○ |
| C-12 | 発行元はdisruption-controller | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 966-967行目の `pdb.Namespace, pdb.Namespace` は `pdb.Namespace, pdb.Name` のタイポの可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 966-967行目の pdb.Namespace 重複がバグかどうかの確認
- [ ] DeletionTimeout（2分）の妥当性確認
