---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：130-SystemOOM

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/oom/oom_watcher_linux.go` 74-95行目 - Start関数
- E-02: `pkg/kubelet/oom/oom_watcher_linux.go` 83行目 - VictimContainerNameフィルタ
- E-03: `pkg/kubelet/oom/oom_watcher_linux.go` 85-88行目 - メッセージ構築
- E-04: `pkg/kubelet/oom/oom_watcher_linux.go` 89行目 - SystemOOMイベント発行
- E-05: `pkg/kubelet/oom/oom_watcher_linux.go` 39-42行目 - realWatcher構造体
- E-06: `pkg/kubelet/oom/oom_watcher_linux.go` 48-66行目 - NewWatcher関数
- E-07: `pkg/kubelet/oom/oom_watcher_linux.go` 68-71行目 - 定数定義
- E-08: `pkg/kubelet/oom/oom_watcher_linux.go` 1行目 - ビルドタグ
- E-09: `pkg/kubelet/oom/oom_watcher_linux.go` 75行目 - チャネルバッファサイズ
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 131行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VictimContainerName == "/" でシステムレベルOOMを判定 | E-02, E-07 | ○ |
| C-02 | Warning SystemOOMイベントが発行される | E-04 | ○ |
| C-03 | プロセス情報があればメッセージに追加される | E-03 | ○ |
| C-04 | プロセス名とPIDの条件分岐がある | E-03 (86行目 event.ProcessName != "" && event.Pid != 0) | ○ |
| C-05 | 非同期でgoroutineが監視する | E-01 (78行目 go func) | ○ |
| C-06 | cAdvisorのOomParserを使用する | E-06 (55行目) | ○ |
| C-07 | Linux専用機能 | E-08 | ○ |
| C-08 | outStreamチャネルのバッファサイズは10 | E-09 | ○ |
| C-09 | FakeRecorder使用時はnilを返す | E-06 (50-53行目) | ○ |
| C-10 | ストリーム停止時にエラーログ出力 | E-01 (92行目) | ○ |
| C-11 | Node オブジェクトにイベントが記録される | E-04 (ref引数) | ○ |
| C-12 | 発行元はkubelet oom watcher | E-10 | ○ |
| C-13 | systemOOMEvent定数は"SystemOOM" | E-07 (69行目) | ○ |
| C-14 | recordEventContainerName定数は"/" | E-07 (70行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなファイルで全体が明確に把握できる

## 6) レビュアーチェックリスト（最小）
- [ ] cAdvisor OomParser のストリーム信頼性確認
- [ ] 非Linux環境でのフォールバック実装確認（oom_watcher_unsupported.go）
