---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：131-MultipleSELinuxLabels

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **レート制限仕様**：Kubernetes Event APIのデフォルトレート制限の具体的な値が未確認
  2. **RBACポリシー詳細**：selinux-warningコントローラ固有のRBAC設定の詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` - メインコントローラ実装
- E-02: `pkg/controller/volume/selinuxwarning/cache/volumecache.go` - ボリュームキャッシュ実装
- E-03: `pkg/volume/util/selinux.go` - SELinuxユーティリティ（MultipleSELinuxLabelsError定義）
- E-04: `pkg/controller/volume/selinuxwarning/metrics.go` - メトリクス定義
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（No.131の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventTypeはWarningである | E-01 (473行目), E-05 | ○ |
| C-02 | 発行元コンポーネントはselinux_warningである | E-01 (98行目) | ○ |
| C-03 | Pod内の同一ボリュームが異なるSELinuxラベルの場合にMultipleSELinuxLabelsイベントが発行される | E-01 (472-473行目), E-03 (287-289行目) | ○ |
| C-04 | 異なるPod間での競合でSELinuxLabelConflictイベントが発行される | E-02 (151-168行目) | ○ |
| C-05 | SELinuxChangePolicyの競合でSELinuxChangePolicyConflictイベントが発行される | E-02 (133-150行目) | ○ |
| C-06 | コントローラはPod、PVC、PV、CSIDriverのInformerを監視する | E-01 (142-174行目) | ○ |
| C-07 | RateLimitingQueueによるリトライが実装されている | E-01 (117-122行目, 405行目) | ○ |
| C-08 | PodがFailed/Succeeded状態の場合にキャッシュから削除される | E-01 (424-428行目) | ○ |
| C-09 | SELinuxChangePolicyがRecursiveの場合は空ラベルとして扱われる | E-01 (516-519行目) | ○ |
| C-10 | CSIDriverのSELinuxMountフラグ変更時にPodが再評価される | E-01 (301-348行目) | ○ |
| C-11 | コントローラはオプションでSELinux無効時は何もしない | E-01 (55-58行目コメント) | ○ |
| C-12 | ボリュームスペック作成失敗時はスキップして継続する | E-01 (451-455行目) | ○ |
| C-13 | メッセージテンプレート「Volume %q is mounted twice with different SELinux labels inside this pod」 | E-01 (473行目) | ○ |
| C-14 | Conflict構造体にEventReasonとEventMessage()メソッドがある | E-02 (30-50行目付近) | ○ |
| C-15 | メトリクスがPrometheusで監視可能 | E-04 | ○ |
| C-16 | コントローラは全Podのボリューム競合を報告する（ノードアフィニティに関わらず） | E-01 (60-62行目コメント) | ○ |
| C-17 | Kubernetes Event APIのデフォルトレート制限に従う | **根拠なし** | △ |
| C-18 | RBACによる適切な権限制御が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Kubernetes Event APIのレート制限の具体的な数値が特定できなかった
  - 候補：client-goのEventBroadcaster実装 / API Serverのイベントレート制限設定
- selinux-warningコントローラのRBAC ClusterRoleの詳細設定
  - 候補：`plugin/pkg/auth/authorizer/rbac/bootstrappolicy/controller_policy.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知の基本的なトリガー条件、メッセージ内容、処理フローはソースコードから正確に読み取れている
- 1: 中リスク - レート制限の具体値とRBAC設定の詳細は推測に基づく部分がある

## 6) レビュアーチェックリスト（最小）
- [ ] MultipleSELinuxLabelsイベントのメッセージ形式がソースコード473行目と一致するか確認
- [ ] SELinuxLabelConflictとSELinuxChangePolicyConflictのイベント理由がvolumeCache実装と整合するか確認
- [ ] コントローラがSELinux無効環境で実際に何もしないことを確認
- [ ] レート制限の記述が実際のKubernetes Event API制限と整合するか確認
