---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：132-CertificateOverdueForRefresh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **PodCertificateProjection機能ゲート依存関係**：具体的なFeatureGate名の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/podcertificate/podcertificatemanager.go` - PodCertificateManager本体実装
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（No.132の定義）
- E-03: `staging/src/k8s.io/api/certificates/v1beta1/types.go` - PodCertificateRequest API型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventTypeはWarningである | E-01 (556行目) | ○ |
| C-02 | Reason文字列は「CertificateOverdueForRefresh」 | E-01 (556行目, 679行目) | ○ |
| C-03 | メッセージは「PodCertificate refresh overdue」 | E-01 (556行目, 679行目) | ○ |
| C-04 | refreshOverdueDurationは10分 | E-01 (94行目) | ○ |
| C-05 | credStateFresh状態でbeginRefreshAt+10分超過時に発行 | E-01 (554-558行目) | ○ |
| C-06 | credStateWaitRefresh状態でbeginRefreshAt+10分超過時に発行 | E-01 (677-681行目) | ○ |
| C-07 | eventEmittedForOverdueForRefreshフラグで重複発行を抑止 | E-01 (554, 557, 677, 680行目) | ○ |
| C-08 | フラグはcredStateFresh→credStateWaitRefresh遷移時に引き継がれる | E-01 (597行目) | ○ |
| C-09 | runRefreshPassは1分間隔で実行 | E-01 (346行目) | ○ |
| C-10 | jitterDurationは0-5分のランダム遅延 | E-01 (698-700行目) | ○ |
| C-11 | PCR削除検知後credStateInitialに戻る | E-01 (476-487行目) | ○ |
| C-12 | 証明書秘密鍵はメモリ上でのみ保持 | E-01 (129行目 credStore定義) | ○ |
| C-13 | NoOpManagerは静的/切り離しモード用 | E-01 (984-1002行目) | ○ |
| C-14 | PodCertificateRequest作成時にOwnerReferenceにPodを設定 | E-01 (766-772行目) | ○ |
| C-15 | PodCertificateProjection機能ゲートに依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PodCertificateProjection機能を有効にするFeatureGateの具体的な名前がpodcertificatemanager.go内に直接記載されていない
  - 候補：`pkg/features/kube_features.go` / kubelet起動パラメータ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行ロジック、条件、メッセージはソースコードから正確に確認済み
- 0: 低リスク - 状態遷移とフラグ管理のロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] CertificateOverdueForRefreshのメッセージ文字列がソースコード556行目と一致するか確認
- [ ] refreshOverdueDurationの値（10分）がソースコード94行目と一致するか確認
- [ ] eventEmittedForOverdueForRefreshフラグが正しく状態遷移間で引き継がれるか確認
- [ ] PodCertificateProjection機能ゲートの名前を確認
