---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：133-CertificateExpired

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **期限切れ証明書がgetCredBundleで返され続ける点**：セキュリティ観点でレビュー推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/podcertificate/podcertificatemanager.go` - PodCertificateManager本体実装
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（No.133の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventTypeはWarningである | E-01 (563行目, 686行目) | ○ |
| C-02 | Reason文字列は「CertificateExpired」 | E-01 (563行目, 686行目) | ○ |
| C-03 | メッセージは「PodCertificate expired」 | E-01 (563行目, 686行目) | ○ |
| C-04 | credStateFresh状態でnow > notAfter時に発行 | E-01 (561-564行目) | ○ |
| C-05 | credStateWaitRefresh状態でnow > notAfter時に発行 | E-01 (684-688行目) | ○ |
| C-06 | eventEmittedForExpirationフラグで重複発行を抑止 | E-01 (561-564, 684-688行目) | ○ |
| C-07 | フラグはcredStateFresh→credStateWaitRefresh遷移時に引き継がれる | E-01 (598行目) | ○ |
| C-08 | CertificateExpiredはCertificateOverdueForRefreshの後に発行される | E-01 (554-564行目の順序) | ○ |
| C-09 | metricsStateでnotAfter超過時に「expired」を返す | E-01 (230-231行目, 259-260行目) | ○ |
| C-10 | 期限切れ後も古い証明書がgetCredBundleで返される | E-01 (225-227行目, 254-256行目) | ○ |
| C-11 | runRefreshPassは1分間隔 | E-01 (346行目) | ○ |
| C-12 | イベントメッセージに証明書詳細情報は含まれない | E-01 (563行目) | ○ |
| C-13 | PCR削除検知後credStateFreshに戻る（WaitRefresh時） | E-01 (624-631行目) | ○ |
| C-14 | TLSハンドシェイクへの影響についての記述 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 期限切れ証明書が実際にTLSハンドシェイク失敗を引き起こすかはアプリケーション側の実装依存
  - 候補：各アプリケーションのTLS設定 / Go標準ライブラリのTLS実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行ロジックとメッセージ内容はソースコードから正確に確認済み
- 1: 中リスク - 期限切れ証明書がcredStoreに残り続ける動作のセキュリティ影響の評価

## 6) レビュアーチェックリスト（最小）
- [ ] CertificateExpiredのメッセージ文字列がソースコード563行目と一致するか確認
- [ ] eventEmittedForExpirationフラグが正しく状態遷移間で引き継がれるか確認
- [ ] 期限切れ証明書がgetCredBundleで引き続き返される動作の意図を確認
- [ ] CertificateOverdueForRefreshとCertificateExpiredの発行順序が正しいか確認
