---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：134-HealthCheckNodePort

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **kube-proxy同期間隔**：具体的な同期間隔の確認が必要
  2. **通知名称の整合性**：CSV上の通知名「HealthCheckNodePort」とイベントReason「FailedToStartServiceHealthcheck」の対応関係の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/proxy/healthcheck/service_health.go` - ServiceHealthServer実装
- E-02: `pkg/proxy/serviceport.go` - ServicePortインターフェースとHealthCheckNodePortフィールド
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（No.134の定義）
- E-04: `pkg/proxy/servicechangetracker.go` - Service変更追跡

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventTypeはWarningである | E-01 (143行目: api.EventTypeWarning) | ○ |
| C-02 | Reason文字列は「FailedToStartServiceHealthcheck」 | E-01 (143行目) | ○ |
| C-03 | Action文字列は「Listen」 | E-01 (143行目) | ○ |
| C-04 | メッセージに ノード名、Service名、ポート番号、エラー詳細が含まれる | E-01 (134行目) | ○ |
| C-05 | SyncServicesメソッド内で発行される | E-01 (104-151行目) | ○ |
| C-06 | recorderがnilでない場合にのみイベント発行 | E-01 (136行目) | ○ |
| C-07 | listenAndServeAllが失敗した場合にイベント発行 | E-01 (131-147行目) | ○ |
| C-08 | 失敗時に既開始のリスナーをロールバック | E-01 (179行目) | ○ |
| C-09 | エンドポイント数0またはプロキシ不健全で503を返す | E-01 (239-243行目) | ○ |
| C-10 | ヘルスチェックレスポンスはJSON形式 | E-01 (244-253行目) | ○ |
| C-11 | NodePortAddresses取得失敗時は全アドレスでリスン | E-01 (65-72行目) | ○ |
| C-12 | HealthCheckNodePortはService.Spec.HealthCheckNodePortから取得 | E-02 (231-237行目) | ○ |
| C-13 | externalTrafficPolicy=Localの場合にHealthCheckが必要 | E-02 (231行目: apiservice.NeedsHealthCheck) | ○ |
| C-14 | kube-proxyの同期間隔は設定依存 | **根拠なし** | △ |
| C-15 | 通知名「HealthCheckNodePort」とReason「FailedToStartServiceHealthcheck」の対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- kube-proxyの同期間隔のデフォルト値
  - 候補：kube-proxy起動パラメータ `--sync-period` / proxier実装
- 通知一覧CSV上の通知名「HealthCheckNodePort」がイベントReason「FailedToStartServiceHealthcheck」を指すことの明確な対応付け
  - 候補：通知一覧の定義基準 / 備考欄の記載

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 通知名とイベントReasonの不一致は混乱を招く可能性がある
- 0: 低リスク - イベント発行ロジック自体はソースコードから正確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FailedToStartServiceHealthcheckのメッセージ形式がソースコード134行目と一致するか確認
- [ ] 通知一覧CSV上の「HealthCheckNodePort」がこのイベントを正しく指しているか確認
- [ ] kube-proxyの同期間隔のデフォルト値を確認
- [ ] events.EventRecorderインターフェースの使用法（通常のrecord.EventRecorderとの違い）を確認
