---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ResizeInfeasible

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 38行目 - ResizeInfeasible定数
- E-02: `pkg/kubelet/allocation/allocation_manager.go` 591-601行目 - IsInPlacePodVerticalScalingAllowedチェック
- E-03: `pkg/kubelet/allocation/allocation_manager.go` 637-638行目 - Infeasible時のeventType設定
- E-04: `pkg/kubelet/allocation/allocation_manager.go` 709-728行目 - canResizePodのInfeasible判定
- E-05: `pkg/kubelet/allocation/allocation_manager.go` 278-279行目 - InfeasibleのPodがリストに再追加されない
- E-06: `pkg/kubelet/allocation/allocation_manager.go` 593, 600, 607, 718, 726行目 - PodInfeasibleResizesメトリクス
- E-07: `pkg/kubelet/allocation/allocation_manager.go` 648-659行目 - disallowResizeForSwappableContainers

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数はResizeInfeasible = "ResizeInfeasible" | E-01 | ○ |
| C-02 | EventTypeはWarning | E-03 | ○ |
| C-03 | Infeasibleの場合はpendingResizesリストに再追加されない | E-05 | ○ |
| C-04 | Guaranteed QoS + CPU Manager staticでCPUリサイズがInfeasible | E-04 | ○ |
| C-05 | Guaranteed QoS + Memory Manager staticでメモリリサイズがInfeasible | E-04 | ○ |
| C-06 | スワップ対応コンテナのリサイズがInfeasible | E-07 | ○ |
| C-07 | IsInPlacePodVerticalScalingAllowedの不可判定 | E-02 | ○ |
| C-08 | PodInfeasibleResizesメトリクスにカウントされる | E-06 | ○ |
| C-09 | SetPodResizePendingConditionがtrueの場合のみ発行 | E-03 | ○ |
| C-10 | canResizePodから返却される | E-04 | ○ |
| C-11 | ノードAllocatable超過もInfeasibleに該当する | E-04 | ○ |
| C-12 | ExclusiveCPUs/ExclusiveMemory機能ゲートで回避可能 | E-04 | ○ |
| C-13 | ResizeDeferredとメッセージ生成関数を共有 | E-03 | ○ |
| C-14 | PodResizePendingMsgでJSON形式メッセージを生成 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。全ての主張がソースコードで確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] canResizePodのノードAllocatable超過がDeferred/Infeasibleのどちらに分類されるか詳細確認
- [ ] disallowResizeForSwappableContainersの具体的な判定条件を確認
