---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Pulled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 48行目 - PulledImage定数
- E-02: `pkg/kubelet/images/image_manager.go` 244-245行目 - ローカルイメージ存在時のPulled発行
- E-03: `pkg/kubelet/images/image_manager.go` 257-258行目 - アクセス可能判定時のPulled発行
- E-04: `pkg/kubelet/images/image_manager.go` 374-375行目 - プル完了時のPulled発行
- E-05: `pkg/kubelet/images/image_manager.go` 376行目 - ImagePullDurationメトリクス
- E-06: `pkg/kubelet/images/image_manager.go` 377行目 - バックオフGC
- E-07: `pkg/kubelet/images/image_manager.go` 372行目 - RecordImageFinishedPulling

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数はPulledImage = "Pulled" | E-01 | ○ |
| C-02 | EventTypeはNormal | E-02, E-03, E-04 | ○ |
| C-03 | 3箇所のPulled発行ポイントがある | E-02, E-03, E-04 | ○ |
| C-04 | ケース1: "already present on machine" | E-02 | ○ |
| C-05 | ケース2: "already present on machine and can be accessed by the pod" | E-03 | ○ |
| C-06 | ケース3: "Successfully pulled image" | E-04 | ○ |
| C-07 | プル所要時間とイメージサイズが含まれる | E-04 | ○ |
| C-08 | pullDurationはミリ秒単位切り捨て | E-04 | ○ |
| C-09 | imagePullDurationは待機含む総時間 | E-04 | ○ |
| C-10 | ImagePullDurationメトリクスが記録される | E-05 | ○ |
| C-11 | バックオフGCが実行される | E-06 | ○ |
| C-12 | RecordImageFinishedPullingが呼ばれる | E-07 | ○ |
| C-13 | KubeletEnsureSecretPulledImages有効時のフロー | E-03 | ○ |
| C-14 | logIt関数経由でイベント記録される | E-02, E-03, E-04 | ○ |
| C-15 | プル失敗時はFailedToPullImageが代わりに発行される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。全ての主張がソースコードで確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] KubeletEnsureSecretPulledImages機能ゲート有効時のMustAttemptImagePullの判定ロジックを確認
- [ ] imagePullResult.pullDurationとtime.Since(startTime)の差分が「待機時間」として正しいか確認
- [ ] イメージサイズバケットの分類基準を確認
