---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：24-BackOff_PullImage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **backoffの具体的な初期値と最大値**：flowcontrol.Backoffの初期化パラメータの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 52行目 - BackOffPullImage = "BackOff"
- E-02: `pkg/kubelet/images/types.go` 29行目 - ErrImagePullBackOff = errors.New("ImagePullBackOff")
- E-03: `pkg/kubelet/images/image_manager.go` 337-350行目 - backoffチェックとBackOffイベント発行
- E-04: `pkg/kubelet/images/image_manager.go` 336行目 - backOffKey生成ロジック
- E-05: `pkg/kubelet/images/image_manager.go` 363行目 - backOff.Next()呼び出し
- E-06: `pkg/kubelet/images/image_manager.go` 368行目 - prevPullErrMsg.Store()
- E-07: `pkg/kubelet/images/image_manager.go` 352行目 - prevPullErrMsg.Delete()
- E-08: `pkg/kubelet/images/image_manager.go` 377行目 - backOff.GC()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はBackOffでEventType: Normal | E-01, E-03 | ○ |
| C-02 | backOff.IsInBackOffSinceUpdateがtrueの時に発行 | E-03 | ○ |
| C-03 | メッセージは"Back-off pulling image..." | E-03 | ○ |
| C-04 | 前回エラーメッセージがある場合は付加される | E-03 | ○ |
| C-05 | ErrImagePullBackOffが返却される | E-02, E-03 | ○ |
| C-06 | backOffKeyはpodUID_image形式 | E-04 | ○ |
| C-07 | プル失敗時にbackOff.Next()が呼ばれる | E-05 | ○ |
| C-08 | プル失敗時にprevPullErrMsgにエラーが保存される | E-06 | ○ |
| C-09 | バックオフ期間外のリトライ時にprevPullErrMsgが削除される | E-07 | ○ |
| C-10 | プル成功時にbackOff.GC()が実行される | E-08 | ○ |
| C-11 | CRIランタイムへのプルリクエストは送信されない | E-03 (return前にプルなし) | ○ |
| C-12 | kubeletのimageManagerが発行元 | E-03 | ○ |
| C-13 | exponential backoffでリトライ間隔が管理される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- flowcontrol.Backoffの初期化パラメータ（初期バックオフ時間、最大バックオフ時間）はkubelet.go内のNewImageManager呼び出し時に設定される
  - 候補：`pkg/kubelet/kubelet.go`のNewImageManager呼び出し部分 / `client-go/util/flowcontrol/backoff.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはソースコードから直接確認済み
- 1: 中リスク - backoffの具体的な時間パラメータは未確認

## 6) レビュアーチェックリスト（最小）
- [ ] flowcontrol.Backoffの初期化パラメータ（初期値、最大値、リセット間隔）を確認
- [ ] prevPullErrMsgのメモリ管理（無制限成長のリスク）を確認
