---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-NodeNotReady

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 58行目 - NodeNotReady = "NodeNotReady"
- E-02: `pkg/kubelet/nodestatus/setters.go` 543-546行目 - NodeNotReadyイベント発行とログ出力
- E-03: `pkg/kubelet/nodestatus/setters.go` 505-513行目 - エラー時のConditionFalse設定
- E-04: `pkg/kubelet/nodestatus/setters.go` 491行目 - エラーソース一覧
- E-05: `pkg/kubelet/nodestatus/setters.go` 521-535行目 - ステータス変更検知
- E-06: `pkg/kubelet/kubelet_node_status.go` 633-636行目 - recordNodeStatusEvent
- E-07: `pkg/kubelet/nodestatus/setters_test.go` 1300行目 - NodeNotReadyイベントテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はNodeNotReadyでEventType: Normal | E-01, E-02 | ○ |
| C-02 | NodeReady条件がTrue→Falseに遷移した場合に発行 | E-02, E-05 | ○ |
| C-03 | メッセージは"Node {ノード名} status is now: NodeNotReady" | E-06 | ○ |
| C-04 | EventTypeはWarningではなくNormal | E-02 | ○ |
| C-05 | runtimeErrors, networkErrors, storageErrors, shutdownManagerErrorsがチェックされる | E-04 | ○ |
| C-06 | エラーがある場合Reason: "KubeletNotReady" | E-03 | ○ |
| C-07 | NodeNotReady遷移時にklog.Infoで詳細がログ出力される | E-02 (545-546行目) | ○ |
| C-08 | ステータス変更なしの場合は発行されない | E-05 | ○ |
| C-09 | 初回設定時は遷移として扱われない | E-05 | ○ |
| C-10 | recordNodeStatusEventでEventf呼び出し | E-06 | ○ |
| C-11 | missingCapacitiesもNotReady原因になる | E-03 (492-504行目) | ○ |
| C-12 | aggregated errorsがMessageに含まれる | E-03 | ○ |
| C-13 | syncNodeStatusから定期的に呼ばれる | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] EventType: Normalが意図通りか確認（Warningではない理由の妥当性）
- [ ] NodeNotReady状態におけるPodエビクションの動作を確認（node controller側の処理）
