---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-NodeSchedulable

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 59行目 - NodeSchedulable = "NodeSchedulable"
- E-02: `pkg/kubelet/kubelet_node_status.go` 644-656行目 - recordNodeSchedulableEvent関数
- E-03: `pkg/kubelet/kubelet_node_status.go` 649-652行目 - Unschedulable=falseの場合の分岐
- E-04: `pkg/kubelet/kubelet_node_status.go` 633-636行目 - recordNodeStatusEvent
- E-05: `pkg/kubelet/kubelet_node_status.go` 701行目 - defaultNodeStatusFuncsへの登録

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はNodeSchedulableでEventType: Normal | E-01, E-03 | ○ |
| C-02 | Unschedulable true→false遷移時に発行 | E-02, E-03 | ○ |
| C-03 | メッセージは"Node {ノード名} status is now: NodeSchedulable" | E-04 | ○ |
| C-04 | lastNodeUnschedulableと比較して遷移を検知 | E-02 | ○ |
| C-05 | lastNodeUnschedulableLockで排他制御 | E-02 (645行目) | ○ |
| C-06 | lastNodeUnschedulableが更新される | E-02 (653行目) | ○ |
| C-07 | recordNodeSchedulableEventは常にnilを返す | E-02 (655行目) | ○ |
| C-08 | defaultNodeStatusFuncsの最後に登録 | E-05 | ○ |
| C-09 | recordNodeStatusEventでEventf呼び出し | E-04 | ○ |
| C-10 | nodeRefに対してイベントが記録される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] kubectl uncordon操作とnode.Spec.Unschedulable変更の関係を確認
- [ ] lastNodeUnschedulableの初期値（kubelet起動時）を確認
