---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：3-Failed (CreateContainer)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **syncPodのリトライ間隔**：デフォルト10秒は推定値
  2. **エラーメッセージの具体的な内容パターン**：実行時の状況に依存
  3. **イメージプル失敗とCreateContainer失敗の区別**：同一Reasonだがメッセージで区別

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 23行目 - FailedToCreateContainer定数定義
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 217行目 - イメージプル失敗時のFailedイベント
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 249行目 - ターゲットID取得失敗時
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 259行目 - 設定生成失敗時
- E-05: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 265行目 - リソース設定失敗時
- E-06: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 272行目 - PreCreateContainerフック失敗時
- E-07: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 279行目 - CRI CreateContainer失敗時
- E-08: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1763行目 - SyncPod内のFailedイベント
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 4行目 - 通知No.3の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数は"Failed"として定義されている | E-01 | ○ |
| C-02 | EventTypeはWarningである | E-02, E-07 | ○ |
| C-03 | イメージプル失敗時にFailedイベントが発行される | E-02 | ○ |
| C-04 | ターゲットID取得失敗時にFailedイベントが発行される | E-03 | ○ |
| C-05 | コンテナ設定生成失敗時にFailedイベントが発行される | E-04 | ○ |
| C-06 | リソース設定失敗時にFailedイベントが発行される | E-05 | ○ |
| C-07 | PreCreateContainerフック失敗時にFailedイベントが発行される | E-06 | ○ |
| C-08 | CRI CreateContainer RPC失敗時にFailedイベントが発行される | E-07 | ○ |
| C-09 | メッセージにgRPCエラーが含まれる | E-02, E-07 | ○ |
| C-10 | SyncPod内でもFailedイベントが発行される | E-08 | ○ |
| C-11 | 発行元はkubelet | E-09 | ○ |
| C-12 | FailedToCreateContainerとFailedToStartContainerは同じReason値 | E-01 | ○ |
| C-13 | syncPodのリトライ間隔がデフォルト10秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- syncPodの再試行間隔のデフォルト値は、kubeletの`--sync-frequency`フラグのデフォルト値に依存するが、本設計書作成時に確認が不十分
  - 候補：`pkg/kubelet/kubelet.go` のデフォルト設定 / `cmd/kubelet/app/options/` の起動オプション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 複数のFailedイベント発行箇所をすべて特定済み
- 1: 中リスク - エラーメッセージの具体的パターンは実行時依存

## 6) レビュアーチェックリスト（最小）
- [ ] startContainer関数内の6箇所のFailedイベント発行を網羅的に確認
- [ ] SyncPod内の追加のFailedイベント発行（1763行目）を確認
- [ ] FailedToCreateContainerとFailedToStartContainerのReason値が同一であることの影響を確認
