---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：32-Shutdown

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Windows版Preshutdown通知の詳細メカニズム**：Windows版の実装詳細は部分的にしか確認できていない

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 75行目 - NodeShutdown定数定義
- E-02: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` 79-106行目 - NewManager初期化
- E-03: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` 265-268行目 - イベント記録ロジック
- E-04: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` 42行目 - dbusReconnectPeriod定数
- E-05: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` 80行目 - Feature Gate チェック
- E-06: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` 312行目 - processShutdownEvent
- E-07: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_windows.go` 69-100行目 - Windows版NewManager

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数名がNodeShutdown="Shutdown"である | E-01 | ○ |
| C-02 | EventTypeがNormalである | E-03 | ○ |
| C-03 | シャットダウン検知時のメッセージが"Shutdown manager detected shutdown event" | E-03 | ○ |
| C-04 | キャンセル時のメッセージが"Shutdown manager detected shutdown cancellation" | E-03 | ○ |
| C-05 | GracefulNodeShutdown Feature Gateが必要 | E-05 | ○ |
| C-06 | D-Bus再接続間隔が1秒 | E-04 | ○ |
| C-07 | processShutdownEventでPodのGraceful Shutdownが実行される | E-06 | ○ |
| C-08 | LinuxではsystemdのInhibitメカニズムを使用 | E-02, E-03 | ○ |
| C-09 | Windows版が存在しWindowsGracefulNodeShutdown Feature Gateが必要 | E-07 | ○ |
| C-10 | ShutdownGracePeriod未設定時はManagerが無効化される | E-02 | ○ |
| C-11 | シャットダウンキャンセル時にInhibitLockが再取得される | E-03 | ○ |
| C-12 | ノードオブジェクトに対してイベントが発行される | E-03 | ○ |
| C-13 | Pod終了順序がPriority値に基づく | E-06 | ○ |
| C-14 | Windows版ではPreshutdown通知を使用する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: Windows版のPreshutdown通知メカニズムの詳細実装は、nodeshutdown_manager_windows.goの全体を精査する必要がある
  - 候補：nodeshutdown_manager_windows.goの完全なStart()実装 / Windows Service API ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Linux版の主要ロジックはソースコードから十分に確認されている
- 1: 中リスク - Windows版の実装詳細は部分的な確認にとどまる

## 6) レビュアーチェックリスト（最小）
- [ ] Linux版とWindows版で同一のイベントReasonが使用されているか確認
- [ ] EventTypeがNormalであることがCSV通知一覧と一致するか確認
- [ ] Graceful Shutdown処理のPod終了順序ロジックの正確性を確認
