---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-FailedNodeAllocatableEnforcement

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 78行目 - FailedNodeAllocatableEnforcement定数
- E-02: `pkg/kubelet/cm/node_container_manager_linux.go` 102-103行目 - cgroupルート失敗時イベント
- E-03: `pkg/kubelet/cm/node_container_manager_linux.go` 112-113行目 - SystemReserved失敗時イベント
- E-04: `pkg/kubelet/cm/node_container_manager_linux.go` 121-122行目 - KubeReserved失敗時イベント
- E-05: `pkg/kubelet/cm/node_container_manager_linux.go` 131-132行目 - SystemReservedCompressible失敗時
- E-06: `pkg/kubelet/cm/node_container_manager_linux.go` 141-142行目 - KubeReservedCompressible失敗時

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数名がFailedNodeAllocatableEnforcement | E-01 | ○ |
| C-02 | EventTypeがWarningである | E-02 | ○ |
| C-03 | cgroupルートは1分間隔でリトライ | E-02 | ○ |
| C-04 | 5種類のメッセージパターンがある | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-05 | Reserved cgroup失敗時はエラーreturn | E-03 | ○ |
| C-06 | cgroupルート失敗時はリトライ継続 | E-02 | ○ |
| C-07 | メッセージにcgroup名とエラー詳細が含まれる | E-02, E-03 | ○ |
| C-08 | Linux環境専用 | E-02 | ○ |
| C-09 | ノードオブジェクトに対してイベントが発行される | E-02 | ○ |
| C-10 | No.35 NodeAllocatableEnforcedと対になる | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各制限タイプの失敗メッセージが正確か確認
- [ ] Reserved cgroup失敗時にkubelet起動が停止するかの挙動確認
