---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：4-Failed (StartContainer)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **Pod同期間隔の具体値**：デフォルト値の確認が必要
  2. **PreStartContainerフックの具体的な処理内容**：フック内で何が行われるか
  3. **セキュリティコンテキスト起因のエラー**：具体的なエラーパターン

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 24行目 - FailedToStartContainer定数定義
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 285行目 - PreStartContainerフック失敗時
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 294行目 - StartContainer RPC失敗時
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 84-102行目 - recordContainerEvent関数
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 5行目 - 通知No.4の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数は"Failed"として定義されている | E-01 | ○ |
| C-02 | EventTypeはWarningである | E-02, E-03 | ○ |
| C-03 | PreStartContainerフック失敗時にFailedイベントが発行される | E-02 | ○ |
| C-04 | CRI StartContainer RPC失敗時にFailedイベントが発行される | E-03 | ○ |
| C-05 | PreStartContainerフック失敗時のメッセージが"Internal PreStartContainer hook failed:" | E-02 | ○ |
| C-06 | StartContainer RPC失敗時のメッセージが"Error:" | E-03 | ○ |
| C-07 | recordContainerEvent関数でイベント記録される | E-04 | ○ |
| C-08 | 発行元はkubelet | E-05 | ○ |
| C-09 | FailedToStartContainerとFailedToCreateContainerは同じReason値 | E-01 | ○ |
| C-10 | syncPodのリトライ間隔の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Pod同期のリトライ間隔のデフォルト値は`--sync-frequency`フラグで制御されるが、設計書で具体値を記載していない
  - 候補：`cmd/kubelet/app/options/options.go` / `pkg/kubelet/config/` のデフォルト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 2箇所のFailedイベント発行を特定済み
- 0: 低リスク - メッセージフォーマットの違いを明記済み

## 6) レビュアーチェックリスト（最小）
- [ ] 285行目と294行目のFailedイベント発行を確認
- [ ] PreStartContainerフックが何を行うか確認
- [ ] FailedToCreateContainerとの区別方法を確認
