---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-AlreadyMountedVolume

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 71行目 - WarnAlreadyMountedVolume定数定義
- E-02: `pkg/volume/local/local.go` 568行目 - AlreadyMountedVolumeイベント発行
- E-03: `pkg/volume/local/local.go` 542行目 - IsNotMountPointチェック
- E-04: `pkg/volume/local/local.go` 549行目 - 既マウント時の早期リターン
- E-05: `pkg/volume/local/local.go` 553行目 - FsGroupチェック
- E-06: `pkg/volume/local/local.go` 560行目 - filterPodMounts
- E-07: `pkg/volume/local/local.go` 561行目 - refs長さチェック
- E-08: `pkg/volume/local/local.go` 562-563行目 - fsGroupNew/fsGroupOld取得
- E-09: `pkg/volume/local/local.go` 567行目 - GID比較
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 48行目 - 通知No.47定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AlreadyMountedVolumeはWarningイベント | E-02 | ○ |
| C-02 | Podオブジェクトに対して記録される | E-02 | ○ |
| C-03 | ローカルボリュームプラグイン固有 | E-02 (local.go) | ○ |
| C-04 | メッセージにfsGroupNewとfsGroupOldが含まれる | E-02 | ○ |
| C-05 | fsGroupがnilの場合チェックスキップ | E-05 | ○ |
| C-06 | 他Podマウントがない場合チェックスキップ | E-06, E-07 | ○ |
| C-07 | fsGroup一致時はイベント発行なし | E-09 | ○ |
| C-08 | 既マウント済みの場合早期リターン | E-03, E-04 | ○ |
| C-09 | filterPodMountsで自Pod除外 | E-06 | ○ |
| C-10 | 定数名WarnAlreadyMountedVolumeと文字列"AlreadyMountedVolume"が異なる | E-01 | ○ |
| C-11 | マウント処理はWarning後も続行 | E-02 (568行目後にマウント処理続行) | ○ |
| C-12 | GetOwnerでGID取得 | E-08 | ○ |
| C-13 | メッセージに"The volume may not be shareable."が含まれる | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] filterPodMountsの実装詳細（自Podの判定ロジック）確認
- [ ] ローカルボリューム以外のプラグインでのfsGroup不一致時の挙動確認
