---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-FailedMountOnFilesystemMismatch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 83行目 - FailedMountOnFilesystemMismatch定数定義
- E-02: `pkg/volume/util/operationexecutor/operation_generator.go` 661-671行目 - checkForFailedMount関数
- E-03: `pkg/volume/util/operationexecutor/operation_generator.go` 667行目 - IsFilesystemMismatchError判定
- E-04: `pkg/volume/util/operationexecutor/operation_generator.go` 669行目 - PVに対するイベント発行
- E-05: `pkg/volume/util/operationexecutor/operation_generator.go` 662-664行目 - PV nilチェック
- E-06: `pkg/volume/util/operationexecutor/operation_generator.go` 550行目 - MountDevice失敗時の呼び出し
- E-07: `pkg/volume/util/operationexecutor/operation_generator.go` 602行目 - SetUp失敗時の呼び出し
- E-08: `pkg/volume/util/types/types.go` 189-194行目 - IsFilesystemMismatchError関数
- E-09: `pkg/volume/util/types/types_test.go` 36行目 - テストケース
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 51行目 - 通知No.50定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailedMountOnFilesystemMismatchはWarningイベント | E-04 | ○ |
| C-02 | PVオブジェクトに対して記録される（PodやPVCではない） | E-04 | ○ |
| C-03 | PVがnilの場合はスキップ | E-05 | ○ |
| C-04 | IsFilesystemMismatchErrorで判定 | E-03, E-08 | ○ |
| C-05 | errors.As()によりラップエラーに対応 | E-08 (193行目) | ○ |
| C-06 | mount.MountError型のFilesystemMismatchで判定 | E-08 | ○ |
| C-07 | MountDevice失敗時に呼ばれる | E-06 | ○ |
| C-08 | SetUp失敗時に呼ばれる | E-07 | ○ |
| C-09 | checkForFailedMount関数内でのみ発行 | E-02 | ○ |
| C-10 | GenerateMsgでメッセージ生成 | E-02 (668行目) | ○ |
| C-11 | PodにはFailedMountVolumeが別途発行される | E-07 (eventRecorderFunc) | ○ |
| C-12 | テストケースでFilesystemMismatch検証済み | E-09 | ○ |
| C-13 | ラップエラーのテストも存在 | E-09 (48行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードとテストコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] mount.FilesystemMismatchエラーの具体的な発生条件確認
- [ ] PVに対するイベント発行がRBACに与える影響確認（Namespace横断の可能性）
