---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-FailedBinding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **PV Controller再同期間隔の具体値**：コード上で直接確認できず

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/volume/events/event.go` 21行目 - FailedBinding定数定義
- E-02: `pkg/controller/volume/persistentvolume/pv_controller.go` 381行目 - Normal FailedBinding（StorageClass未設定）
- E-03: `pkg/controller/volume/persistentvolume/pv_controller.go` 470行目 - Warning FailedBinding（ユーザ指定PV既バインド）
- E-04: `pkg/controller/volume/persistentvolume/pv_controller.go` 481行目 - Warning FailedBinding（コントローラバインドPV既バインド）
- E-05: `pkg/controller/volume/ephemeral/controller.go` 245行目 - Warning FailedBinding（エフェメラルボリューム）
- E-06: `pkg/controller/volume/ephemeral/controller.go` 237-240行目 - DeletionTimestampチェック
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 53行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント名がFailedBindingである | E-01 | ○ |
| C-02 | PV ControllerとEphemeral Volume Controllerの2箇所から発行 | E-02, E-03, E-04, E-05 | ○ |
| C-03 | StorageClass未設定時にNormalイベントとして発行 | E-02 | ○ |
| C-04 | PV既バインド時にWarningイベントとして発行 | E-03, E-04 | ○ |
| C-05 | メッセージ「no persistent volumes available...」がStorageClass未設定時に使用 | E-02 | ○ |
| C-06 | メッセージ「volume already bound to a different claim」がPV既バインド時に使用 | E-03, E-04 | ○ |
| C-07 | エフェメラルボリュームコントローラからもFailedBindingが発行される | E-05 | ○ |
| C-08 | エフェメラルボリュームの場合Podに対してイベント発行 | E-05 | ○ |
| C-09 | Pod削除中のエフェメラルボリュームは無視される | E-06 | ○ |
| C-10 | PVCのステータスがPendingに維持される | E-02 (周辺コード) | ○ |
| C-11 | StorageClass設定時は動的プロビジョニングが試行される | E-02 (周辺コード) | ○ |
| C-12 | 発行元がpv controller / ephemeral volume controller | E-07 | ○ |
| C-13 | space shuttle styleで全分岐が明示的に処理されている | E-02 (コメント) | ○ |
| C-14 | PV Controllerの再同期間隔は設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: PV Controllerの具体的な再同期間隔（resyncPeriod）はコントローラ初期化時のパラメータに依存しており、pv_controller.go単体からは確定できない。
  - 候補：kube-controller-manager起動パラメータ / コントローラ初期化コード

## 5) リスクフラグ（レビュー観点）
- 0: イベント定数定義と発行ロジック（コードで明確に確認済み）
- 0: 2つのコントローラからの発行パターン（コードで確認済み）
- 1: 再同期間隔の具体値（設定依存）

## 6) レビュアーチェックリスト（最小）
- [ ] PV Controller再同期間隔のデフォルト値を確認
- [ ] エフェメラルボリュームコントローラのhandleVolumeで発生しうるエラーパターンを網羅的に確認
- [ ] FailedBinding発行時のEventType（Normal/Warning）の使い分けが正確か確認
