---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：53-VolumeMismatch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **checkVolumeSatisfyClaimの内部チェック項目詳細**：関数の実装詳細を直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/volume/events/event.go` 22行目 - VolumeMismatch定数定義
- E-02: `pkg/controller/volume/persistentvolume/pv_controller.go` 437-441行目 - checkVolumeSatisfyClaim失敗時のVolumeMismatch発行
- E-03: `pkg/controller/volume/persistentvolume/pv_controller.go` 691行目 - CheckVolumeModeMismatches呼び出し
- E-04: `pkg/controller/volume/persistentvolume/pv_controller.go` 695行目 - PVへのVolumeMismatchイベント発行
- E-05: `pkg/controller/volume/persistentvolume/pv_controller.go` 697行目 - PVCへのVolumeMismatchイベント発行
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 54行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント名がVolumeMismatchである | E-01 | ○ |
| C-02 | EventTypeがWarningである | E-02, E-04, E-05 | ○ |
| C-03 | 発行元がpv controllerである | E-06 | ○ |
| C-04 | PVC指定PVの要件不一致時に発行 | E-02 | ○ |
| C-05 | volumeMode不一致時にPVとPVC両方にイベント発行 | E-04, E-05 | ○ |
| C-06 | メッセージ形式「Cannot bind to requested volume」 | E-02 | ○ |
| C-07 | メッセージ形式「incompatible volumeMode」 | E-04, E-05 | ○ |
| C-08 | VolumeName未指定時はcheckVolumeSatisfyClaimが呼ばれない | E-02 (コードフロー) | ○ |
| C-09 | PVCステータスがPendingに更新される | E-02 (周辺コード443行目) | ○ |
| C-10 | コントローラ同期ループにより再試行される | E-02 (コードフロー) | ○ |
| C-11 | checkVolumeSatisfyClaimが容量・アクセスモード・ノードアフィニティをチェック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11: checkVolumeSatisfyClaim関数の内部実装を直接読み込んでいない。チェック項目は一般的なKubernetes知識に基づく推測。
  - 候補：checkVolumeSatisfyClaim関数の実装コード / Kubernetes公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: イベント定数定義と発行ロジック（コードで明確に確認済み）
- 0: volumeMode不一致時のPV・PVC両方へのイベント発行（コードで確認済み）
- 1: checkVolumeSatisfyClaimの内部チェック項目（推測含む）

## 6) レビュアーチェックリスト（最小）
- [ ] checkVolumeSatisfyClaim関数の実装を確認し、チェック項目一覧の正確性を検証
- [ ] CheckVolumeModeMismatchesの実装を確認し、不一致判定条件を検証
