---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-ExternalProvisioning

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/volume/events/event.go` 28行目 - ExternalProvisioning定数定義
- E-02: `pkg/controller/volume/persistentvolume/pv_controller.go` 1857行目 - ExternalProvisioningイベント発行
- E-03: `pkg/controller/volume/persistentvolume/pv_controller.go` 1852-1854行目 - メッセージ構築
- E-04: `pkg/controller/volume/persistentvolume/pv_controller.go` 1832行目 - CSI移行チェック
- E-05: `pkg/controller/volume/persistentvolume/pv_controller.go` 1843行目 - setClaimProvisioner呼び出し
- E-06: `pkg/controller/volume/persistentvolume/pv_controller.go` 1599行目 - plugin==nil時のexternal呼び出し
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 58行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント名がExternalProvisioningである | E-01 | ○ |
| C-02 | EventTypeがNormalである | E-02 | ○ |
| C-03 | メッセージに外部プロビジョナー名とガイダンスが含まれる | E-03 | ○ |
| C-04 | CSI移行が有効な場合にプラグイン名が変換される | E-04 | ○ |
| C-05 | setClaimProvisionerでPVCにアノテーション設定後に発行 | E-05, E-02 | ○ |
| C-06 | in-treeプラグインが見つからない場合にexternal処理が呼ばれる | E-06 | ○ |
| C-07 | PVCオブジェクトに対して発行される | E-02 | ○ |
| C-08 | 発行元がpv controllerである | E-07 | ○ |
| C-09 | CSI名変換失敗時はProvisioningFailedが発行される | E-04 (周辺コード1838行目) | ○ |
| C-10 | アノテーション設定失敗時はProvisioningFailedが発行される | E-05 (周辺コード1848行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] setClaimProvisionerで設定されるアノテーション名を確認
- [ ] 外部プロビジョナーがアノテーションを監視する仕組みを把握
