---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-ProvisioningFailed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/volume/events/event.go` 29行目 - ProvisioningFailed定数定義
- E-02: `pkg/controller/volume/persistentvolume/pv_controller.go` 1586行目 - findProvisionablePlugin失敗
- E-03: `pkg/controller/volume/persistentvolume/pv_controller.go` 1633行目 - DataSource+non-CSI
- E-04: `pkg/controller/volume/persistentvolume/pv_controller.go` 1688行目 - マウントオプション非対応
- E-05: `pkg/controller/volume/persistentvolume/pv_controller.go` 1697行目 - プロビジョナー作成失敗
- E-06: `pkg/controller/volume/persistentvolume/pv_controller.go` 1707行目 - ノード取得失敗
- E-07: `pkg/controller/volume/persistentvolume/pv_controller.go` 1724行目 - ボリュームプロビジョニング失敗
- E-08: `pkg/controller/volume/persistentvolume/pv_controller.go` 1782行目 - PVオブジェクト作成失敗
- E-09: `pkg/controller/volume/persistentvolume/pv_controller.go` 1838行目 - CSI名変換失敗
- E-10: `pkg/controller/volume/persistentvolume/pv_controller.go` 1848行目 - PVC保存失敗
- E-11: `pkg/controller/volume/persistentvolume/pv_controller.go` 124-127行目 - リトライ定数
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 59行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント名がProvisioningFailedである | E-01 | ○ |
| C-02 | EventTypeがWarningである | E-02 ~ E-10 | ○ |
| C-03 | 9箇所から発行される | E-02 ~ E-10 | ○ |
| C-04 | findProvisionablePlugin失敗時に発行 | E-02 | ○ |
| C-05 | DataSource + non-CSI時に発行 | E-03 | ○ |
| C-06 | マウントオプション非対応時に発行 | E-04 | ○ |
| C-07 | プロビジョナー作成失敗時に発行 | E-05 | ○ |
| C-08 | ノード取得失敗時に発行 | E-06 | ○ |
| C-09 | ボリュームプロビジョニング失敗時に発行 | E-07 | ○ |
| C-10 | PVオブジェクト作成失敗時に発行 | E-08 | ○ |
| C-11 | CSI名変換失敗時に発行 | E-09 | ○ |
| C-12 | PVC保存失敗時に発行 | E-10 | ○ |
| C-13 | PVオブジェクト作成リトライは5回 | E-11 | ○ |
| C-14 | PVオブジェクト作成リトライ間隔は10秒 | E-11 | ○ |
| C-15 | PVCオブジェクトに対して発行される | E-02 ~ E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全9箇所の発行ロジックがソースコードで確認済み
- 0: リトライ定数がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] findProvisionablePluginの内部実装を確認し、プラグイン検索ロジックを把握
- [ ] rescheduleProvisioningの動作を確認（ボリュームプロビジョニング失敗時に呼ばれる）
