---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：59-ProvisioningCleanupFailed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **外部プロビジョナーではProvisioningCleanupFailedが発生しないという主張**：外部プロビジョナーの動作仕様の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/volume/events/event.go` 30行目 - ProvisioningCleanupFailed定数定義
- E-02: `pkg/controller/volume/persistentvolume/pv_controller.go` 1805-1810行目 - ProvisioningCleanupFailedイベント発行
- E-03: `pkg/controller/volume/persistentvolume/pv_controller.go` 1786-1803行目 - ボリューム削除リトライ
- E-04: `pkg/controller/volume/persistentvolume/pv_controller.go` 1750-1773行目 - PVオブジェクト作成リトライ
- E-05: `pkg/controller/volume/persistentvolume/pv_controller.go` 124行目 - リトライ回数定数
- E-06: `pkg/controller/volume/persistentvolume/pv_controller.go` 127行目 - リトライ間隔定数
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 60行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント名がProvisioningCleanupFailedである | E-01 | ○ |
| C-02 | EventTypeがWarningである | E-02 | ○ |
| C-03 | PVオブジェクト作成失敗後かつボリューム削除も失敗した場合に発行 | E-02, E-03, E-04 | ○ |
| C-04 | メッセージに「Please delete manually」が含まれる | E-02 | ○ |
| C-05 | ボリューム削除は5回リトライされる | E-03, E-05 | ○ |
| C-06 | リトライ間隔は10秒 | E-03, E-06 | ○ |
| C-07 | 自動回復が不可能 | E-02 (コード構造から判断) | ○ |
| C-08 | PVCオブジェクトに対して発行される | E-02 | ○ |
| C-09 | 発行元がpv controllerである | E-07 | ○ |
| C-10 | 外部プロビジョナーの場合はこのイベントが発生しない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: provisionClaimOperationExternal内にはPVオブジェクト作成処理が含まれないことからの推測。外部プロビジョナーの動作仕様として、PVオブジェクト作成は外部プロビジョナーが担当するため、この推測は妥当だが直接的な根拠はない。
  - 候補：外部プロビジョナー（CSI sidecar）のソースコード / CSI仕様

## 5) リスクフラグ（レビュー観点）
- 0: イベント定数定義と発行ロジック（コードで明確に確認済み）
- 0: リトライ回数と間隔（コードで確認済み）
- 2: 孤立ボリュームの手動削除が必要（運用上の高リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] 外部プロビジョナーの場合にProvisioningCleanupFailedが発生しないことを確認
- [ ] 孤立ボリュームの特定方法と手動削除手順を運用マニュアルに記載すべきか検討
- [ ] doDeleteVolumeの実装を確認し、具体的な削除失敗パターンを把握
