---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：6-Preempting

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **プリエンプションメッセージの具体的な内容**：messageの生成箇所の確認
  2. **getPodsToPreemptのPod選出ロジック**：優先度判定の詳細
  3. **admitPodからの呼び出しパス**：HandleAdmitの呼び出し元確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 26行目 - PreemptContainer定数定義
- E-02: `pkg/kubelet/preemption/preemption.go` 102行目 - Preemptingイベント発行箇所
- E-03: `pkg/kubelet/preemption/preemption.go` 94行目 - evictPodsToFreeRequests関数定義
- E-04: `pkg/kubelet/preemption/preemption.go` 96行目 - getPodsToPreempt呼び出し
- E-05: `pkg/kubelet/preemption/preemption.go` 105-116行目 - killPodFuncおよびPodStatus更新
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 7行目 - 通知No.6の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数は"Preempting"として定義されている | E-01 | ○ |
| C-02 | evictPodsToFreeRequests内でPreemptingイベントが発行される | E-02, E-03 | ○ |
| C-03 | EventTypeはWarningである | E-02 | ○ |
| C-04 | プリエンプト対象PodリストのループでEventfが呼ばれる | E-02 | ○ |
| C-05 | killPodFunc呼び出し前にイベントが発行される | E-02, E-05 | ○ |
| C-06 | PodStatusがFailed/Preemptingに更新される | E-05 | ○ |
| C-07 | DisruptionTarget条件が設定される | E-05 | ○ |
| C-08 | getPodsToPreemptでプリエンプト対象が選出される | E-04 | ○ |
| C-09 | 発行元はkubelet | E-06 | ○ |
| C-10 | リソース不足理由でのみプリエンプションが発生する | E-03 | ○ |
| C-11 | recorder.Eventf関数で直接イベント記録される | E-02 | ○ |
| C-12 | messageの具体的な内容とその生成ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- message変数の具体的な内容は、evictPodsToFreeRequests関数のスコープ外（呼び出し元のHandleAdmitメソッド等）で生成されている可能性があり、確認が不十分
  - 候補：`pkg/kubelet/preemption/preemption.go` の上位関数 / `pkg/kubelet/lifecycle/` のアドミッション処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プリエンプション処理の基本構造は確認済み
- 1: 中リスク - メッセージ内容の具体的なフォーマットは未確認

## 6) レビュアーチェックリスト（最小）
- [ ] evictPodsToFreeRequests関数内のPreemptingイベント発行（102行目）を確認
- [ ] message変数の生成元を確認
- [ ] getPodsToPreemptの選出ロジックを確認
- [ ] DisruptionTarget条件の設定内容を確認
