---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-SandboxChanged

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 行80 - SandboxChanged定数定義
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1394-1409 - SyncPodメソッドのイベント発行部分
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1405 - Eventf呼び出し（EventTypeNormal, SandboxChanged）
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1404 - SandboxID存在チェック
- E-05: `pkg/kubelet/kuberuntime/util/util.go` 行30-69 - PodSandboxChanged関数
- E-06: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1124 - computePodActionsでのPodSandboxChanged呼び出し
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行65 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はSandboxChangedである | E-01, E-03 | ○ |
| C-02 | EventTypeはNormalである | E-03, E-07 | ○ |
| C-03 | 発行元はkubelet runtime managerである | E-02, E-07 | ○ |
| C-04 | 固定メッセージ「Pod sandbox changed, it will be killed and re-created.」 | E-03 | ○ |
| C-05 | Podオブジェクトに対するEventとして発行される | E-02 (ref.GetReference) | ○ |
| C-06 | SandboxIDが空の場合はイベント発行されない | E-04 | ○ |
| C-07 | PodSandboxChanged関数がサンドボックス変更を判定する | E-05, E-06 | ○ |
| C-08 | サンドボックスが存在しない場合は変更ありと判定 | E-05 (行33-35) | ○ |
| C-09 | 複数のReadyサンドボックスがある場合は変更ありと判定 | E-05 (行47-49) | ○ |
| C-10 | ネットワーク名前空間が変更された場合は変更ありと判定 | E-05 (行57-59) | ○ |
| C-11 | IPアドレスがない場合は変更ありと判定 | E-05 (行63-65) | ○ |
| C-12 | サンドボックス変更時は全コンテナが再作成される | E-02 (行1412-1428) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] PodSandboxChanged関数の5つの判定条件が正確に記述されているか確認
- [ ] SandboxIDが空の場合の挙動が正しく記述されているか確認
