---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-FailedPodSandBoxStatus

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 行82 - FailedStatusPodSandBox定数（値: "FailedPodSandBoxStatus"）
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1568-1577 - ステータス取得とイベント発行
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1574 - Eventf呼び出し（EventTypeWarning）
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 行1566 - createPodSandbox成功後のログ
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行67 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はFailedPodSandBoxStatusである | E-01, E-03 | ○ |
| C-02 | EventTypeはWarningである | E-03, E-05 | ○ |
| C-03 | 発行元はkubelet runtime managerである | E-02, E-05 | ○ |
| C-04 | メッセージは「Unable to get pod sandbox status: {err}」 | E-03 | ○ |
| C-05 | createPodSandbox成功後に発行される | E-04, E-02 | ○ |
| C-06 | runtimeService.PodSandboxStatusの呼び出し失敗時に発行 | E-02 (行1568) | ○ |
| C-07 | result.Failでエラーが記録される | E-02 (行1576) | ○ |
| C-08 | Go定数名とReason文字列が異なる | E-01 | ○ |
| C-09 | ステータスがnilの場合はイベントではなくresult.Failのみ | E-02 (行1579-1581) | ○ |
| C-10 | Podオブジェクトに対するEventとして発行される | E-02 (ref.GetReference) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Go定数名（FailedStatusPodSandBox）とReason文字列（FailedPodSandBoxStatus）の違いが正確に記述されているか確認
- [ ] ステータスnil時の挙動が正しく記述されているか確認
