---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：67-Unhealthy

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **maxProbeRetriesの具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 行97 - ContainerUnhealthy定数（値: "Unhealthy"）
- E-02: `pkg/kubelet/prober/prober.go` 行83-134 - probeメソッド
- E-03: `pkg/kubelet/prober/prober.go` 行107 - recordContainerEvent呼び出し（エラー時）
- E-04: `pkg/kubelet/prober/prober.go` 行123 - recordContainerEvent呼び出し（Failure時）
- E-05: `pkg/kubelet/prober/prober.go` 行117 - ProbeWarning（Warning時）
- E-06: `pkg/kubelet/prober/prober.go` 行102 - runProbeWithRetries呼び出し
- E-07: `pkg/kubelet/prober/prober.go` 行126-128 - Unknown時の処理
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行68 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント理由はUnhealthyである | E-01, E-03 | ○ |
| C-02 | EventTypeはWarningである | E-03, E-08 | ○ |
| C-03 | 発行元はkubelet proberである | E-02, E-08 | ○ |
| C-04 | Failure時「{probeType} probe failed: {output}」 | E-04 | ○ |
| C-05 | エラー時「{probeType} probe errored and resulted in {result} state: {error}」 | E-03 | ○ |
| C-06 | 3種類のProbe（Liveness/Readiness/Startup）で発行される | E-02 (行84-94) | ○ |
| C-07 | Success時はイベント発行されない | E-02 (行112-114) | ○ |
| C-08 | Unknown時はイベント発行されない | E-07 | ○ |
| C-09 | Warning時はProbeWarningが発行される | E-05 | ○ |
| C-10 | recordContainerEventでイベントを記録する | E-03, E-04 | ○ |
| C-11 | runProbeWithRetriesでプローブ実行される | E-06 | ○ |
| C-12 | maxProbeRetries回のリトライが行われる | E-06 | ○ |
| C-13 | maxProbeRetriesの具体値 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- maxProbeRetriesの具体値がprober.goの該当範囲では確認できない
  - 候補：prober.goのファイル上部の定数定義 / 別ファイルでの定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知の基本ロジックは全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] プローブ失敗時とエラー時のメッセージフォーマットが正確か確認
- [ ] Success/Warning/Failure/Unknownの4つの分岐が正しく記述されているか確認
- [ ] maxProbeRetriesの値を補完する必要があるか検討
