---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：7-BackOff

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **バックオフの初期値と最大値**：指数バックオフの具体的なパラメータ
  2. **doBackOffの呼び出し元**：SyncPod内の正確な呼び出し箇所
  3. **バックオフキーの生成ロジック**：GetBackoffKeyの実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 27行目 - BackOffStartContainer定数定義
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1843行目 - BackOffイベント発行箇所
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1836-1854行目 - doBackOff関数全体
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1838行目 - FinishedAt参照
- E-05: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1840行目 - GetBackoffKey
- E-06: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1841行目 - IsInBackOffSince判定
- E-07: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` 1849行目 - NewBackoffError
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 8行目 - 通知No.7の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数は"BackOff"として定義されている | E-01 | ○ |
| C-02 | doBackOff関数内でBackOffイベントが発行される | E-02, E-03 | ○ |
| C-03 | EventTypeはWarningである | E-02 | ○ |
| C-04 | メッセージは"Back-off restarting failed container..." | E-02 | ○ |
| C-05 | バックオフ判定はIsInBackOffSinceで行われる | E-06 | ○ |
| C-06 | 起点時刻はcStatus.FinishedAtである | E-04 | ○ |
| C-07 | バックオフキーはGetBackoffKeyで生成される | E-05 | ○ |
| C-08 | ErrCrashLoopBackOffエラーが返却される | E-07 | ○ |
| C-09 | GenerateContainerRef成功時のみイベント発行 | E-02 | ○ |
| C-10 | 発行元はkubelet | E-08 | ○ |
| C-11 | バックオフは指数的に増加する | E-03 | ○ |
| C-12 | バックオフの初期値と最大値の具体的な数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- バックオフの初期値（例：10秒）と最大値（例：5分）の具体的な数値は、flowcontrolのBackOff実装に依存するが本設計書では具体値を記載していない
  - 候補：`staging/src/k8s.io/apimachinery/pkg/util/wait/backoff.go` / kubeletの初期化コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行の基本構造は確認済み
- 1: 中リスク - バックオフの具体パラメータは推定

## 6) レビュアーチェックリスト（最小）
- [ ] doBackOff関数内のBackOffイベント発行（1843行目）を確認
- [ ] バックオフの初期値・最大値をkubelet初期化コードで確認
- [ ] SyncPodからdoBackOffへの呼び出しパスを確認
