---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：71-InvalidDiskCapacity

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 行91-93 - InvalidDiskCapacity定数定義
- E-02: `pkg/kubelet/images/image_gc_manager.go` 行384-388 - capacity==0チェックとイベント発行
- E-03: `pkg/kubelet/images/image_gc_manager.go` 行348-417 - GarbageCollectメソッド全体
- E-04: `pkg/kubelet/images/image_gc_manager.go` 行88-106 - ImageGCPolicy構造体
- E-05: `pkg/kubelet/images/image_gc_manager.go` 行108-140 - realImageGCManager構造体
- E-06: `pkg/kubelet/images/image_gc_manager.go` 行365-376 - ImageFsStats取得とcapacity/available抽出
- E-07: `pkg/kubelet/images/image_gc_manager.go` 行217-236 - Start()メソッド（5分間隔の定期実行）
- E-08: `pkg/kubelet/images/image_gc_manager.go` 行66-70 - StatsProviderインタフェース
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 行72 - 通知一覧でのInvalidDiskCapacityの定義
- E-10: `pkg/kubelet/images/image_gc_manager.go` 行191-215 - NewImageGCManager()コンストラクタ
- E-11: `pkg/kubelet/images/image_gc_manager.go` 行386 - recorder.Eventfの呼び出し形式
- E-12: `pkg/kubelet/images/image_gc_manager.go` 行385 - エラーメッセージ "invalid capacity 0 on image filesystem"

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InvalidDiskCapacityはWarningイベントとして発行される | E-02 (v1.EventTypeWarning) | ○ |
| C-02 | 容量が0バイトの場合に発行される | E-02 (capacity == 0) | ○ |
| C-03 | イベント定数はpkg/kubelet/events/event.goで定義 | E-01 | ○ |
| C-04 | GarbageCollect()内で発行される | E-03 | ○ |
| C-05 | メッセージは "invalid capacity 0 on image filesystem" | E-12 | ○ |
| C-06 | nodeRefを送信先として使用 | E-02 (im.nodeRef) | ○ |
| C-07 | 5分間隔で定期実行される | E-07 (5*time.Minute) | ○ |
| C-08 | StatsProviderからImageFsStatsを取得 | E-06, E-08 | ○ |
| C-09 | ImageGCPolicyにHighThresholdPercent/LowThresholdPercentがある | E-04 | ○ |
| C-10 | realImageGCManagerがrecorderとnodeRefを保持 | E-05 | ○ |
| C-11 | 発行元はkubelet image gc manager | E-09 | ○ |
| C-12 | エラーを返却しGC処理を中断する | E-02, E-03 (return err) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコードの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードによって裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GarbageCollect()のcapacity==0チェック（行384-388）がコードと一致するか確認
- [ ] イベントメッセージの内容が正確か確認
- [ ] 5分間隔の記述がStart()メソッドと一致するか確認
