---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-FreeDiskSpaceFailed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/events/event.go` 行92 - FreeDiskSpaceFailed定数
- E-02: `pkg/kubelet/images/image_gc_manager.go` 行403-412 - freed < amountToFreeチェックとイベント発行
- E-03: `pkg/kubelet/images/image_gc_manager.go` 行391-393 - usagePercent計算とHighThreshold比較
- E-04: `pkg/kubelet/images/image_gc_manager.go` 行407-410 - メッセージテンプレート
- E-05: `pkg/kubelet/images/image_gc_manager.go` 行395 - freeSpace()呼び出し
- E-06: `pkg/kubelet/images/image_gc_manager.go` 行482-521 - freeSpace()メソッド
- E-07: `pkg/kubelet/images/image_gc_manager.go` 行594-617 - formatSize()関数
- E-08: `pkg/kubelet/images/image_gc_manager.go` 行88-106 - ImageGCPolicy構造体
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 行73 - 通知一覧での定義
- E-10: `pkg/kubelet/images/image_gc_manager.go` 行365 - ImageFsStats取得
- E-11: `pkg/kubelet/images/image_gc_manager.go` 行411 - recorder.Eventf呼び出し
- E-12: `pkg/kubelet/images/image_gc_manager.go` 行523-545 - freeImage()メソッド
- E-13: `pkg/kubelet/images/image_gc_manager.go` 行491-503 - lastUsedとMinAgeのスキップ条件
- E-14: `pkg/kubelet/images/image_gc_manager_test.go` - テストファイルの存在

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeDiskSpaceFailedはWarningイベントとして発行 | E-02, E-11 | ○ |
| C-02 | freed < amountToFreeの場合に発行 | E-02 | ○ |
| C-03 | usagePercent >= HighThresholdPercentでGC発動 | E-03 | ○ |
| C-04 | メッセージに使用率・容量・解放量が含まれる | E-04 | ○ |
| C-05 | formatSizeで人間可読な容量表記が使用される | E-04, E-07 | ○ |
| C-06 | nodeRefを送信先として使用 | E-11 (im.nodeRef) | ○ |
| C-07 | freeSpace()で未使用イメージを削除 | E-05, E-06 | ○ |
| C-08 | 最近使用されたイメージはスキップ | E-13 | ○ |
| C-09 | MinAge未満のイメージはスキップ | E-13 | ○ |
| C-10 | amountToFreeの計算ロジック | E-03 (行393) | ○ |
| C-11 | freeImage()がruntime.RemoveImage()を呼び出す | E-12 | ○ |
| C-12 | イベント定数はevents/event.goで定義 | E-01 | ○ |
| C-13 | 発行元はkubelet image gc manager | E-09 | ○ |
| C-14 | テストファイルが存在する | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコードの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードによって裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] freed < amountToFreeの条件分岐（行403）がコードと一致するか確認
- [ ] メッセージテンプレート（行407-410）の内容が正確か確認
- [ ] freeSpace()のスキップ条件が正しく記載されているか確認
