---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-Scheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/schedule_one.go` 行1021 - Scheduledイベント発行箇所
- E-02: `pkg/scheduler/schedule_one.go` 行1015-1022 - finishBinding()メソッド
- E-03: `pkg/scheduler/schedule_one.go` 行65-136 - ScheduleOne()メソッド
- E-04: `pkg/scheduler/schedule_one.go` 行123-135 - 非同期bindingCycle goroutine
- E-05: `pkg/scheduler/schedule_one.go` 行116 - schedulingCycle()呼び出し
- E-06: `pkg/scheduler/schedule_one.go` 行1016-1018 - バインド失敗時のリターン
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行76 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ScheduledはNormalイベントとして発行 | E-01 (v1.EventTypeNormal) | ○ |
| C-02 | finishBinding()内で発行される | E-02 | ○ |
| C-03 | メッセージは "Successfully assigned %v/%v to %v" | E-01 | ○ |
| C-04 | Reason は "Scheduled"、Action は "Binding" | E-01 | ○ |
| C-05 | Podオブジェクトに紐付くイベント | E-01 (assumed) | ○ |
| C-06 | status.IsSuccess()がfalseの場合は発行されない | E-06 | ○ |
| C-07 | bindingCycleは非同期goroutineで実行 | E-04 | ○ |
| C-08 | ScheduleOne()がエントリーポイント | E-03 | ○ |
| C-09 | schedulingCycleの後にbindingCycleが実行 | E-03, E-05 | ○ |
| C-10 | 発行元はscheduler | E-07 | ○ |
| C-11 | annotationsにnilが渡される | E-01 (nil引数) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコードの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードによって裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] finishBinding()のイベント発行コード（行1021）がドキュメントと一致するか確認
- [ ] Eventfの引数（annotations=nil, Reason="Scheduled", Action="Binding"）が正確か確認
