---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-FailedScheduling

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/schedule_one.go` 行1117 - handleSchedulingFailure内のFailedSchedulingイベント
- E-02: `pkg/scheduler/schedule_one.go` 行407 - skipPodSchedule内のFailedSchedulingイベント
- E-03: `pkg/scheduler/schedule_one.go` 行1035-1127 - handleSchedulingFailure()メソッド
- E-04: `pkg/scheduler/schedule_one.go` 行404-410 - skipPodSchedule()メソッド
- E-05: `pkg/scheduler/schedule_one.go` 行1047-1050 - reason判定ロジック
- E-06: `pkg/scheduler/schedule_one.go` 行1118-1126 - PodCondition更新
- E-07: `pkg/scheduler/schedule_one.go` 行1096 - AddUnschedulableIfNotPresent
- E-08: `pkg/scheduler/schedule_one.go` 行1129-1137 - truncateMessage()関数
- E-09: `pkg/scheduler/schedule_one.go` 行1069-1077 - エラー種別ログ
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行77 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailedSchedulingはWarningイベントとして発行 | E-01, E-02 (v1.EventTypeWarning) | ○ |
| C-02 | 2つの発行箇所がある | E-01, E-02 | ○ |
| C-03 | handleSchedulingFailure内で発行（スケジュール失敗時） | E-01, E-03 | ○ |
| C-04 | skipPodSchedule内で発行（削除中Pod） | E-02, E-04 | ○ |
| C-05 | Reason="FailedScheduling", Action="Scheduling" | E-01, E-02 | ○ |
| C-06 | メッセージはtruncateMessageで切り詰められる | E-08 | ○ |
| C-07 | PodConditionが同時に更新される | E-06 | ○ |
| C-08 | reason: Unschedulable vs SchedulerError | E-05 | ○ |
| C-09 | Podはスケジューリングキューに再投入される | E-07 | ○ |
| C-10 | ErrNoNodesAvailableが特別なケースとして処理 | E-09 (行1069-1070) | ○ |
| C-11 | FitErrorの場合はUnschedulablePlugins情報が保存される | E-09 (行1071-1073) | ○ |
| C-12 | 発行元はscheduler | E-10 | ○ |
| C-13 | 削除中Podのメッセージに namespace/name が含まれる | E-02 | ○ |
| C-14 | NoteLengthLimitで切り詰めが行われる | E-08 (validation.NoteLengthLimit) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコードの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードによって裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 2つのイベント発行箇所（行407, 行1117）がドキュメントと一致するか確認
- [ ] handleSchedulingFailure()のフロー（行1035-1127）が正確に記載されているか確認
- [ ] truncateMessage()の動作が正確か確認
