---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-SelectorRequired

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podautoscaler/horizontal.go` 行400 - SelectorRequiredイベント発行
- E-02: `pkg/controller/podautoscaler/horizontal.go` 行398 - selector == "" チェック
- E-03: `pkg/controller/podautoscaler/horizontal.go` 行401 - setCondition(ScalingActive=False)
- E-04: `pkg/controller/podautoscaler/horizontal.go` 行391-435 - validateAndParseSelector()
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行78 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SelectorRequiredはWarningイベントとして発行 | E-01 (v1.EventTypeWarning) | ○ |
| C-02 | selector が空文字列の場合に発行 | E-02 | ○ |
| C-03 | メッセージは "selector is required" | E-01 | ○ |
| C-04 | HPAオブジェクトに紐付くイベント | E-01 (hpa) | ○ |
| C-05 | validateAndParseSelector内で発行 | E-04 | ○ |
| C-06 | ScalingActive=False条件が同時設定 | E-03 | ○ |
| C-07 | Reason="InvalidSelector"でCondition設定 | E-03 | ○ |
| C-08 | 発行元はhorizontal-pod-autoscaler | E-05 | ○ |
| C-09 | エラーが返却される | E-01 (行402: return nil, errors.New) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] validateAndParseSelector()のセレクタ空チェック（行398-402）がドキュメントと一致するか確認
