---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-AmbiguousSelector

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podautoscaler/horizontal.go` 行429 - AmbiguousSelectorイベント発行
- E-02: `pkg/controller/podautoscaler/horizontal.go` 行427 - len(selectingHpas) > 1 チェック
- E-03: `pkg/controller/podautoscaler/horizontal.go` 行428 - errMsg構築
- E-04: `pkg/controller/podautoscaler/horizontal.go` 行430 - setCondition呼び出し
- E-05: `pkg/controller/podautoscaler/horizontal.go` 行421 - podLister.Pods().List()
- E-06: `pkg/controller/podautoscaler/horizontal.go` 行426 - hpasControllingPodsUnderSelector()
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行80 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AmbiguousSelectorはWarningイベントとして発行 | E-01 (v1.EventTypeWarning) | ○ |
| C-02 | 複数HPAが同一Podを選択している場合に発行 | E-02 | ○ |
| C-03 | メッセージにセレクタとHPA一覧が含まれる | E-03 | ○ |
| C-04 | HPAオブジェクトに紐付くイベント | E-01 (hpa) | ○ |
| C-05 | ScalingActive=False条件が同時設定 | E-04 | ○ |
| C-06 | Reason="AmbiguousSelector"でCondition設定 | E-04 | ○ |
| C-07 | podListerでPodを取得している | E-05 | ○ |
| C-08 | hpasControllingPodsUnderSelectorで競合検出 | E-06 | ○ |
| C-09 | 発行元はhorizontal-pod-autoscaler | E-07 | ○ |
| C-10 | validateAndParseSelectorの第3段階 | E-01 (行429が行398, 405の後) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] hpasControllingPodsUnderSelector()の競合検出ロジック（行426-431）がドキュメントと一致するか確認
