---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-FailedGetScale

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podautoscaler/horizontal.go` 行784 - 第1発行箇所（ParseGroupVersion失敗）
- E-02: `pkg/controller/podautoscaler/horizontal.go` 行799 - 第2発行箇所（RESTMappings失敗）
- E-03: `pkg/controller/podautoscaler/horizontal.go` 行809 - 第3発行箇所（scaleForResourceMappings失敗）
- E-04: `pkg/controller/podautoscaler/horizontal.go` 行785 - setCondition(AbleToScale=False)第1箇所
- E-05: `pkg/controller/podautoscaler/horizontal.go` 行800 - setCondition(AbleToScale=False)第2箇所
- E-06: `pkg/controller/podautoscaler/horizontal.go` 行810 - setCondition(AbleToScale=False)第3箇所
- E-07: `pkg/controller/podautoscaler/horizontal.go` 行816 - 成功時: SucceededGetScale
- E-08: `pkg/controller/podautoscaler/horizontal.go` 行782 - ParseGroupVersion呼び出し
- E-09: `pkg/controller/podautoscaler/horizontal.go` 行797 - RESTMappings呼び出し
- E-10: `pkg/controller/podautoscaler/horizontal.go` 行807 - scaleForResourceMappings呼び出し
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行81 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailedGetScaleはWarningイベントとして発行 | E-01, E-02, E-03 | ○ |
| C-02 | 3箇所で発行される可能性がある | E-01, E-02, E-03 | ○ |
| C-03 | ParseGroupVersion失敗時に発行（第1箇所） | E-01, E-08 | ○ |
| C-04 | RESTMappings失敗時に発行（第2箇所） | E-02, E-09 | ○ |
| C-05 | scaleForResourceMappings失敗時に発行（第3箇所） | E-03, E-10 | ○ |
| C-06 | HPAオブジェクトに紐付くイベント | E-01 (hpa) | ○ |
| C-07 | AbleToScale=False条件が同時設定 | E-04, E-05, E-06 | ○ |
| C-08 | Reason="FailedGetScale"でCondition設定 | E-04 | ○ |
| C-09 | 成功時はSucceededGetScaleが設定される | E-07 | ○ |
| C-10 | エラーメッセージはerr.Error()が使用される | E-01 | ○ |
| C-11 | 発行元はhorizontal-pod-autoscaler | E-11 | ○ |
| C-12 | updateStatusIfNeededが各エラーパスで呼ばれる | E-01 (行786), E-02 (行801), E-03 (行811) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのFailedGetScale発行箇所（行784, 799, 809）がドキュメントと一致するか確認
- [ ] 各エラーパスでsetConditionとupdateStatusIfNeededが正しく呼ばれているか確認
