---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：81-FailedComputeMetricsReplicas

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **resyncPeriod のデフォルト値**：コード内でデフォルト値が明示されていない

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podautoscaler/horizontal.go` 行 862 - FailedComputeMetricsReplicas イベント発行
- E-02: `pkg/controller/podautoscaler/horizontal.go` 行 313-361 - computeReplicasForMetrics 関数
- E-03: `pkg/controller/podautoscaler/horizontal.go` 行 759-972 - reconcileAutoscaler 関数
- E-04: `pkg/controller/podautoscaler/horizontal.go` 行 857-858 - metricDesiredReplicas == -1 の条件判定
- E-05: `pkg/controller/podautoscaler/horizontal.go` 行 147 - EventSource Component: "horizontal-pod-autoscaler"
- E-06: `pkg/controller/podautoscaler/horizontal.go` 行 1088-1096 - getUnableComputeReplicaCountCondition
- E-07: `pkg/controller/podautoscaler/horizontal.go` 行 841-851 - スケーリング無効・境界条件
- E-08: `pkg/controller/podautoscaler/horizontal.go` 行 347-357 - 無効メトリクス判定ロジック
- E-09: `pkg/controller/podautoscaler/horizontal.go` 行 1446-1448 - FailedUpdateStatus イベント
- E-10: `pkg/controller/podautoscaler/horizontal.go` 行 354 - invalidMetricsCount >= len(metricSpecs) 条件
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行 82 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventType は Warning である | E-01, E-11 | ○ |
| C-02 | 発行元は horizontal-pod-autoscaler である | E-05 | ○ |
| C-03 | computeReplicasForMetrics で metricDesiredReplicas == -1 の場合に発行される | E-04 | ○ |
| C-04 | 全メトリクス無効または一部無効+スケールダウン条件で -1 が返る | E-08, E-10 | ○ |
| C-05 | エラーメッセージに無効メトリクス数と最初のエラー詳細が含まれる | E-02 (行 348) | ○ |
| C-06 | currentReplicas == 0 かつ minReplicas != 0 の場合はスキップ | E-07 (行 841) | ○ |
| C-07 | ScalingActive condition が False に設定される | E-06 | ○ |
| C-08 | reconcileAutoscaler 内で呼ばれる | E-03 | ○ |
| C-09 | ステータス更新が行われる | E-03 (行 859) | ○ |
| C-10 | resyncPeriod のデフォルトは15秒 | **根拠なし** | △ |
| C-11 | 5種類のメトリクスソースがある | E-02 (行 466-507) | ○ |
| C-12 | HPA オブジェクトに対する Event として記録される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- resyncPeriod のデフォルト値はコントローラマネージャの起動引数で設定されるため、コード内での明示的なデフォルト値確認が必要
  - 候補：cmd/kube-controller-manager のフラグ定義 / Kubernetes 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックはソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] resyncPeriod のデフォルト値を Kubernetes 公式ドキュメントまたは kube-controller-manager のフラグ定義で確認
- [ ] メトリクス計算失敗時のエラーメッセージ形式が実際の出力と一致するか確認
- [ ] HPA のバージョン（v2）前提が正しいか確認
