---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-RollbackDone

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/deployment/rollback.go` 行 111 - RollbackDone Eventf 呼び出し
- E-02: `pkg/controller/deployment/rollback.go` 行 62-65 - ロールバック成功条件
- E-03: `pkg/controller/deployment/rollback.go` 行 77-103 - rollbackToTemplate 関数
- E-04: `pkg/controller/deployment/rollback.go` 行 80 - EqualIgnoreHash チェック
- E-05: `pkg/controller/deployment/util/deployment_util.go` 行 65 - RollbackDone 定数
- E-06: `pkg/controller/deployment/rollback.go` 行 125-139 - getRollbackTo 関数
- E-07: `pkg/controller/deployment/deployment_controller.go` 行 660-661 - ロールバック判定
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行 89 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventType は Normal である | E-01, E-08 | ○ |
| C-02 | RollbackDone の定数値は "DeploymentRollback" | E-05 | ○ |
| C-03 | メッセージ形式は "Rolled back deployment %q to revision %d" | E-02 (行 64) | ○ |
| C-04 | performedRollback == true かつ err == nil で発行 | E-02 | ○ |
| C-05 | テンプレートが同じ場合は RollbackTemplateUnchanged | E-03 (行 98-99) | ○ |
| C-06 | リビジョンが見つからない場合は RollbackRevisionNotFound | E-02 (行 69) | ○ |
| C-07 | deprecated の rollbackTo アノテーションを使用 | E-06 | ○ |
| C-08 | rollbackTo が 0 の場合は最後のリビジョンを使用 | E-06 (行 43-44) | ○ |
| C-09 | Deployment の更新と rollbackTo 削除が行われる | E-03 (行 102, 119) | ○ |
| C-10 | 発行元は deployment-controller | E-01 (recorder の Component) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] deprecated 機能であることを考慮し、将来的な廃止の影響を確認
