---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：89-ConflictingController

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **hasUnexpectedController の詳細実装**：stateful_set_utils.go の具体的な実装を確認する必要あり

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/statefulset/stateful_pod_control.go` 行 243 - ConflictingController Event 呼び出し
- E-02: `pkg/controller/statefulset/stateful_pod_control.go` 行 240 - hasUnexpectedController チェック
- E-03: `pkg/controller/statefulset/stateful_pod_control.go` 行 227-255 - UpdatePodClaimForRetentionPolicy 関数
- E-04: `pkg/controller/statefulset/stateful_pod_control.go` 行 242 - イベントメッセージ文字列
- E-05: `pkg/controller/statefulset/stateful_pod_control.go` 行 245 - isClaimOwnerUpToDate チェック
- E-06: `pkg/controller/statefulset/stateful_pod_control.go` 行 234-236 - NotFound ハンドリング
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行 90 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventType は Warning である | E-01, E-07 | ○ |
| C-02 | メッセージに PVC 名と "conflicting OwnerReference" が含まれる | E-04 | ○ |
| C-03 | hasUnexpectedController が true の場合に発行 | E-02 | ○ |
| C-04 | PVC が NotFound の場合はスキップ | E-06 | ○ |
| C-05 | イベント発行後も OwnerReference 更新は続行される | E-03 (行 245-251) | ○ |
| C-06 | StatefulSet オブジェクトに対する Event | E-01 (set 引数) | ○ |
| C-07 | メッセージに "manging" というタイポがある | E-04 | ○ |
| C-08 | hasUnexpectedController は PVC の OwnerReference を検査する | E-02 | ○ |
| C-09 | StatefulSetAutoDeletePVC feature gate で制御される | **根拠なし** | △ |
| C-10 | UpdatePodClaimForRetentionPolicy から呼ばれる | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- hasUnexpectedController の詳細実装（stateful_set_utils.go）の確認が必要
  - 候補：`pkg/controller/statefulset/stateful_set_utils.go`
- StatefulSetAutoDeletePVC feature gate との関連は stateful_set.go 等で確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - hasUnexpectedController の判定ロジックの詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] hasUnexpectedController の具体的な判定ロジックを stateful_set_utils.go で確認
- [ ] StatefulSetAutoDeletePVC feature gate が有効な場合のみこの機能が動作するか確認
- [ ] "manging" タイポが修正されているか最新のコードを確認
