---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-SuccessfulCreate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 649 - SuccessfulCreate Eventf 呼び出し
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 609 - jobControl.CreateJob 呼び出し
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 611-614 - NamespaceTerminating 処理
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 615-637 - AlreadyExists 処理
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 638-641 - FailedCreate イベント
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 514-517 - Suspended チェック
- E-07: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 546-563 - StartingDeadlineSeconds チェック
- E-08: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 573-587 - ConcurrencyPolicy チェック
- E-09: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 668-669 - Active リスト・LastScheduleTime 更新
- E-10: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 676-678 - getJobName 関数
- E-11: `pkg/controller/cronjob/cronjob_controllerv2.go` 行 647 - CronJobCreationSkew メトリクス
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 行 91 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventType は Normal である | E-01, E-12 | ○ |
| C-02 | メッセージ形式は "Created job %v" | E-01 | ○ |
| C-03 | CreateJob 成功かつ AlreadyExists でない場合に発行 | E-01, E-04 | ○ |
| C-04 | CronJob が Suspended の場合は Job 作成されない | E-06 | ○ |
| C-05 | StartingDeadlineSeconds 超過で MissSchedule イベント | E-07 | ○ |
| C-06 | ConcurrencyPolicy Forbid で JobAlreadyActive イベント | E-08 | ○ |
| C-07 | NamespaceTerminating で作成スキップ | E-03 | ○ |
| C-08 | Active リストに追加される | E-09 | ○ |
| C-09 | LastScheduleTime が更新される | E-09 | ○ |
| C-10 | Job 名は CronJob 名 + 時刻ハッシュ | E-10 | ○ |
| C-11 | CronJobCreationSkew メトリクスが記録される | E-11 | ○ |
| C-12 | 発行元は cronjob-controller | E-01 (recorder の Component) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] getJobFromTemplate2 の Job テンプレート変換ロジックを確認
- [ ] AlreadyExists 時の Active リスト追加処理が正しく動作するか確認
