---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：91-FailedCreate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **リトライ間隔の具体値**：デフォルトRateLimiterの設定値は推定
  2. **イベントTTLのデフォルト値**：クラスタ設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 行640 - FailedCreateイベント発行
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 行97 - EventSource Component設定
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 行609-642 - Job作成処理とエラーハンドリング
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 行611-614 - NamespaceTerminating処理
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` 行615-637 - AlreadyExists処理
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 行426-674 - syncCronJob全体
- E-07: `pkg/controller/cronjob/utils.go` 行244-267 - getJobFromTemplate2
- E-08: `pkg/controller/cronjob/injection.go` 行103-104 - realJobControl.CreateJob
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 行92 - FailedCreate通知定義
- E-10: `pkg/controller/cronjob/cronjob_controllerv2.go` 行169-186 - processNextWorkItemのリトライロジック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronJobがJobの作成に失敗した際にWarningイベントが発行される | E-01, E-09 | ○ |
| C-02 | EventSourceのComponentは「cronjob-controller」 | E-02 | ○ |
| C-03 | メッセージフォーマットは「Error creating job: %v」 | E-01 | ○ |
| C-04 | NamespaceTerminatingの場合はイベント発行されない | E-04 | ○ |
| C-05 | AlreadyExistsの場合はイベント発行されない | E-05 | ○ |
| C-06 | syncCronJob内のJob作成処理で発行される | E-03, E-06 | ○ |
| C-07 | getJobFromTemplate2でJobオブジェクトが生成される | E-07 | ○ |
| C-08 | realJobControl.CreateJobがAPI Serverに作成リクエストを送る | E-08 | ○ |
| C-09 | ワークキューのrate limitedリトライで自動再試行される | E-10 | ○ |
| C-10 | Spec.Suspendがtrueの場合はJob作成が行われない | E-06 | ○ |
| C-11 | Spec.TimeZoneが無効な場合はUnknownTimeZoneイベントが優先される | E-06 | ○ |
| C-12 | リトライ間隔は初回5ms、最大1000秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12のリトライ間隔の具体値はDefaultControllerRateLimiterの実装に依存しており、cronjobパッケージ内には明示的な記載がない
  - 候補：`k8s.io/client-go/util/workqueue/default_rate_limiters.go` / Kubernetes公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知の発行条件とメッセージフォーマットはソースコードから明確に確認可能
- 1: 中リスク - リトライ間隔の具体値はclient-goの実装依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] FailedCreateイベントの発行条件がソースコード（行638-641）と一致しているか確認
- [ ] NamespaceTerminatingとAlreadyExistsの抑止条件が正しいか確認
- [ ] リトライ間隔の具体値をclient-goのDefaultControllerRateLimiterで確認
