---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：97-MissSchedule

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **MissScheduleが繰り返し発行される動作**：ソースコードのTODOコメントに記載された懸念事項

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 行552 - MissScheduleイベント発行
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 行546-563 - デッドライン判定ロジック
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 行547-549 - tooLate計算
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 行554-563 - TODOコメント（繰り返し通知の問題）
- E-05: `pkg/controller/cronjob/utils.go` 行100-181 - mostRecentScheduleTime関数
- E-06: `pkg/controller/cronjob/utils.go` 行210-223 - nextScheduleTime関数
- E-07: `pkg/controller/cronjob/utils.go` 行188-205 - nextScheduleTimeDuration関数
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行98 - MissSchedule通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スケジュール実行がデッドラインを超過した際にWarningイベントが発行される | E-01, E-08 | ○ |
| C-02 | メッセージフォーマットは「Missed scheduled time to start a job: %s」 | E-01 | ○ |
| C-03 | StartingDeadlineSecondsが未設定の場合はtooLate判定が行われない | E-03 | ○ |
| C-04 | tooLate = scheduledTime + deadline < nowで計算される | E-03 | ○ |
| C-05 | MissSchedule後は次回スケジュール時刻にリキューされる | E-02 | ○ |
| C-06 | mostRecentScheduleTimeでスケジュール時刻を計算する | E-05, E-06 | ○ |
| C-07 | スケジュール時刻はUTC RFC1123Z形式で出力される | E-01 | ○ |
| C-08 | CronJobがSuspend中はスケジュール判定に到達しない | E-02 | ○ |
| C-09 | LastScheduleTimeが更新されないため同じミスを繰り返し検出する可能性 | E-04 | ○ |
| C-10 | ミスしたスケジュールはリトライされない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: MissSchedule後に同じスケジュール時刻でのJob作成がリトライされないという主張は、コードの流れから推論できるが、明示的な「リトライしない」ロジックは記述されていない。次回同期時にtooLateが再度trueとなりMissScheduleが再発行される動作が確認されるのみ
  - 候補：StartingDeadlineSecondsの公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - MissScheduleイベントが同じミスに対して繰り返し発行される可能性がある（ソースコードのTODOコメントで指摘済み）

## 6) レビュアーチェックリスト（最小）
- [ ] デッドライン判定ロジック（行546-563）の条件が正しく記述されているか確認
- [ ] StartingDeadlineSecondsがnilの場合のスキップ動作を確認
- [ ] MissScheduleの繰り返し発行に関するTODOコメントの影響を確認
