---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-UnparseableSchedule

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 行524 - UnparseableScheduleイベント発行
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 行519-526 - パース処理とエラーハンドリング
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 行766-784 - formatSchedule関数
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 行399-405 - updateCronJob内のパース処理
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` 行525 - nil返却（リキューなし）
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 行505-517 - TimeZone/Suspendチェック
- E-07: `pkg/controller/cronjob/cronjob_controllerv2.go` 行767-773 - TZ含む場合のUnsupportedSchedule
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行99 - UnparseableSchedule通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スケジュール表現が解析不能な場合にWarningイベントが発行される | E-01, E-08 | ○ |
| C-02 | メッセージフォーマットは「unparseable schedule: %q : %s」 | E-01 | ○ |
| C-03 | ParseCronScheduleWithPanicRecoveryがエラーを返した場合に発行 | E-02 | ○ |
| C-04 | nil返却によりリキューされない | E-05 | ○ |
| C-05 | Spec.Schedule更新イベントにより再キューされる | E-04 | ○ |
| C-06 | TimeZone不正の場合は先にUnknownTimeZoneが発行される | E-06 | ○ |
| C-07 | Suspend中はスケジュール解析に到達しない | E-06 | ○ |
| C-08 | formatScheduleでTimeZoneプレフィックスが付与される | E-03 | ○ |
| C-09 | Schedule内にTZを含む場合はUnsupportedScheduleが発行される | E-07 | ○ |
| C-10 | updateCronJob内では異なるReason「UnParseableCronJobSchedule」が使用される | E-04 | ○ |
| C-11 | formatScheduleのrecorder引数がnilでない場合にUnsupportedScheduleが発行される | E-03, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠あり。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] スケジュール解析エラー時の処理フロー（行519-526）を確認
- [ ] formatSchedule関数のTZ処理（行766-784）を確認
- [ ] updateCronJobとsyncCronJobで異なるReasonが使用される点を確認
