---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **RBAC設定の具体的な操作手順**：テンプレートに基づく記述であり、実環境での挙動確認が必要
  2. **kuberc機能の記述**：Feature Gate依存機能であり、利用可能状況は環境による
  3. **対応環境のOS一覧**：公式ドキュメントに準拠するが、本リポジトリからの直接的な根拠は限定的
  4. **シェル補完の具体的な設定手順**：一般的な手順であり、バージョンによる差異がありうる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要、技術スタック、ディレクトリ構成
- E-02: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 30件の業務要件定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 160件の機能一覧
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 54件のCLIコマンド（画面相当）一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係122件
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - コマンド階層図と典型的なワークフロー
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 135件のイベント通知一覧
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - 23件のバッチ処理一覧
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/` - kubectlコマンド実装ソースコード
- E-10: `cmd/kubeadm/app/cmd/` - kubeadmコマンド実装ソースコード
- E-11: `pkg/controller/` - コントローラー実装ソースコード
- E-12: `pkg/kubelet/` - Kubelet実装ソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KubernetesはCLIベースのコンテナオーケストレーションプラットフォームである | E-01, E-06 | ○ |
| C-02 | kubectl/kubeadmの2つのCLIツールを通じてクラスタを操作する | E-04, E-09, E-10 | ○ |
| C-03 | 主要業務はワークロード管理、クラスタ管理、ネットワーク管理など8カテゴリである | E-02, E-03 | ○ |
| C-04 | ユーザー種別はクラスタ管理者、名前空間管理者、オペレーター、閲覧者の4種 | E-02, E-03 | ○ |
| C-05 | kubeconfigファイルを使用してクラスタに接続する | E-04 (kubectl config), E-05 | ○ |
| C-06 | kubectl cluster-infoでクラスタ情報を確認できる | E-04 (No.13), E-05 | ○ |
| C-07 | kubectl auth whoamiで現在のユーザー情報を確認できる | E-04 (No.26), E-05 | ○ |
| C-08 | kubectl eventsでイベント一覧を確認できる | E-04 (No.28), E-05 | ○ |
| C-09 | 135件のイベント通知が定義されている | E-07 | ○ |
| C-10 | イベントにはNormal/Warningの2種類がある | E-07 | ○ |
| C-11 | kubectl apply/createでリソースを作成できる | E-04 (No.1, No.30), E-05 | ○ |
| C-12 | kubectl diffで適用前の差分を確認できる | E-04 (No.29), E-05 | ○ |
| C-13 | kubectl get/describeでリソース情報を取得できる | E-04 (No.6, No.19), E-05 | ○ |
| C-14 | kubectl cpでPodとローカル間のファイルコピーが可能 | E-04 (No.25), E-05 | ○ |
| C-15 | ConfigMap/Secretリソースで設定管理ができる | E-03 (No.126-128), E-11 | ○ |
| C-16 | kubectl label/annotateでメタデータを管理できる | E-04 (No.35, No.36), E-05 | ○ |
| C-17 | kubectl rolloutでロールアウト管理ができる | E-04 (No.9), E-05 | ○ |
| C-18 | kubectl scale/autoscaleでスケーリングができる | E-04 (No.10, No.11), E-05 | ○ |
| C-19 | kubectl cordon/drain/uncordonでノードメンテナンスができる | E-04 (No.15-17), E-05 | ○ |
| C-20 | kubectl taintでTaint管理ができる | E-04 (No.18), E-05 | ○ |
| C-21 | kubeadm init/join/reset/upgradeでクラスタ管理ができる | E-04 (No.45-52), E-10 | ○ |
| C-22 | kubectl logsでログ確認、kubectl execでコマンド実行ができる | E-04 (No.20, No.22), E-05 | ○ |
| C-23 | kubectl debugでデバッグ機能が利用できる | E-04 (No.27), E-05 | ○ |
| C-24 | kubectl port-forwardでポートフォワードができる | E-04 (No.23), E-05 | ○ |
| C-25 | kubectl explainでAPIリソースのドキュメントが参照できる | E-04 (No.5), E-05 | ○ |
| C-26 | kubectl config系コマンドでkubeconfig管理ができる | E-04 (No.38), E-05 | ○ |
| C-27 | RBAC管理でcreate role/rolebinding等の操作ができる | E-03 (No.157), E-04 (No.1) | △ |
| C-28 | kuberc設定によるエイリアス管理が可能（feature gate依存） | E-04 (No.44) | △ |
| C-29 | 対応OSはLinux/macOS/Windowsである | **根拠なし** | △ |
| C-30 | シェル補完のbash/zsh/fish/powershell対応 | E-04 (No.37, No.54) | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: RBAC管理の具体的なコマンド操作手順は、kubectl createコマンドのサブコマンドから推定したものであり、画面設計書レベルの詳細な操作フロー記述が不足
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/create/create_role.go` / `create_rolebinding.go` の直接確認
- C-28: kuberc機能はFeature Gateに依存するため、デフォルトで利用可能かどうかの確認が必要
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/kuberc/` のソースコード確認
- C-29: 対応OSの情報はリポジトリのビルドスクリプト（hack/build-cross.sh）から推定可能だが、直接的な一覧は確認していない
  - 候補：`hack/build-cross.sh` / `build/` ディレクトリのビルド設定
- C-30: シェル補完の具体的な設定手順は一般的なkubectl利用方法に基づく記述であり、バージョン固有の動作検証は未実施
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - システム概要、コマンド一覧、基本操作手順（既存ドキュメントと一致）
- 0: 低リスク - イベント・通知の種類と説明（通知一覧CSVと一致）
- 1: 中リスク - 業務フローの5段階構成はテンプレートに基づくKubernetes固有のフロー適応であり、実際の運用フローとの乖離の可能性あり
- 1: 中リスク - RBAC管理の操作手順（具体的なサブコマンドの動作確認が必要）
- 0: 低リスク - トラブルシューティングのエラーメッセージ（Kubernetesの一般的なエラーパターンに基づく）
- 1: 中リスク - kuberc機能の記述（Feature Gate依存、利用可能環境が限定される可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] 業務フロー（STEP1-5）の構成がKubernetesの実運用フローとして妥当か確認
- [ ] 各kubectlコマンドの記述がプロジェクトのバージョン（Go 1.25ベース）と整合しているか確認
- [ ] RBAC管理手順の記述が実環境で正しく動作するか確認
- [ ] kuberc機能の記述について、Feature Gateのデフォルト有効/無効状態を確認
- [ ] エラーメッセージと対処法の内容が最新バージョンで正確か確認
- [ ] ユーザー種別の分類（4種）が実運用の権限モデルと一致しているか確認
- [ ] kubeadm関連の操作手順が最新バージョンのコマンド構文と一致しているか確認
