---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 44
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：44 / 50、根拠なし：6
- 優先レビュー（高）
  1. **NFT-001 APIサーバーレイテンシ合格基準**：具体的な閾値（p99 1秒以内）はコードから直接導出できず推定値
  2. **NFT-006 大規模クラスター負荷テスト条件**：5000ノード構成の具体的パラメータはperformance-configの実測値から推定
  3. **NFT-035 APIレート制限テスト**：レート制限の具体的な閾値・429レスポンスの動作はAPIサーバー設定依存
  4. **NFT-047 etcdストレステスト合格基準**：etcdの許容レイテンシ値はデプロイ環境依存
  5. **NFT-048 コントローラーマネージャー負荷テスト基準**：キューバックログの規定値は環境依存
  6. **NFT-049 ExternalJWT認証テスト**：stagingパッケージの実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/integration/scheduler_perf/misc/performance-config.yaml` - スケジューラー性能テスト構成
- E-02: `test/integration/scheduler_perf/affinity/performance-config.yaml` - Affinityスケジューリング性能構成
- E-03: `test/integration/scheduler_perf/topology_spreading/performance-config.yaml` - TopologySpread性能構成
- E-04: `test/integration/scheduler_perf/volumes/performance-config.yaml` - ボリュームスケジューリング性能構成
- E-05: `test/integration/scheduler_perf/dra/performance-config.yaml` - DRAスケジューリング性能構成
- E-06: `test/integration/servicecidr/perf_test.go` - ServiceCIDR性能テスト
- E-07: `test/e2e/node/kubelet_perf.go` - Kubeletリソース消費量テスト
- E-08: `test/e2e/framework/perf/perf.go` - 性能テストフレームワーク
- E-09: `test/e2e/chaosmonkey/chaosmonkey.go` - ChaosMonkey耐障害性テストフレームワーク
- E-10: `test/e2e/auth/service_accounts.go` - ServiceAccount認証テスト
- E-11: `test/e2e/auth/certificates.go` - 証明書認証テスト
- E-12: `test/e2e/auth/node_authn.go` - ノード認証テスト
- E-13: `test/e2e/auth/node_authz.go` - ノード認可テスト
- E-14: `test/e2e/auth/subjectreviews.go` - SubjectAccessReviewテスト
- E-15: `test/e2e/network/netpol/network_policy.go` - NetworkPolicyテスト
- E-16: `test/e2e/network/netpol/network_policy_api.go` - NetworkPolicy APIテスト
- E-17: `pkg/security/apparmor/validate.go` - AppArmorバリデーション
- E-18: `pkg/auth/authorizer/abac/abac.go` - ABAC認可実装
- E-19: `cmd/kube-apiserver/app/options/options.go` - APIサーバーTLS設定
- E-20: `pkg/kubelet/eviction/eviction_manager.go` - Eviction Manager実装
- E-21: `pkg/probe/http/http.go` - HTTP Probe実装
- E-22: `pkg/probe/grpc/grpc.go` - gRPC Probe実装
- E-23: `pkg/probe/exec/exec.go` - Exec Probe実装
- E-24: `pkg/apis/coordination/types.go` - LeaderElection Lease定義
- E-25: `pkg/apis/core/types.go` - LimitRange/ResourceQuota定義
- E-26: `test/e2e/autoscaling/horizontal_pod_autoscaling.go` - HPAテスト
- E-27: `test/e2e/autoscaling/cluster_size_autoscaling.go` - Cluster Autoscalerテスト
- E-28: `test/e2e/autoscaling/dns_autoscaling.go` - DNS Autoscalingテスト
- E-29: `test/e2e/upgrades/` - アップグレードテストスイート
- E-30: `test/e2e/cloud/` - クラウドプロバイダーテスト
- E-31: `test/e2e/storage/csi_volumes.go` - CSIボリュームテスト
- E-32: `test/e2e/instrumentation/metrics.go` - メトリクステスト
- E-33: `test/e2e/instrumentation/core_events.go` - イベントテスト
- E-34: `test/e2e/instrumentation/logging/` - ロギングテスト
- E-35: `test/e2e_kubeadm/` - kubeadmテスト
- E-36: `cluster/validate-cluster.sh` - クラスターバリデーションスクリプト
- E-37: `test/conformance/` - Conformanceテスト
- E-38: `pkg/controller/daemon/daemon_controller.go` - DaemonSetコントローラー
- E-39: `pkg/kubelet/kubelet_network_linux.go` - Linux固有ネットワーク実装
- E-40: `staging/src/k8s.io/pod-security-admission/` - PodSecurity Admission
- E-41: `staging/src/k8s.io/externaljwt/` - ExternalJWT認証
- E-42: `test/integration/disruption/` - PDB統合テスト
- E-43: `test/integration/etcd/` - etcd統合テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: APIサーバーレイテンシテスト（p99 1秒以内） | E-19 | △ |
| C-02 | NFT-002: スケジューラースループット（毎秒100Pod以上） | E-01 | ○ |
| C-03 | NFT-003: QueueingHints有効時スループット | E-01 | ○ |
| C-04 | NFT-004: Kubeletリソース消費量テスト | E-07 | ○ |
| C-05 | NFT-005: コンテナランタイムリソーステスト | E-07 | ○ |
| C-06 | NFT-006: 大規模クラスター負荷テスト（5000ノード） | E-01 | △ |
| C-07 | NFT-007: Affinityスケジューリング性能テスト | E-02 | ○ |
| C-08 | NFT-008: TopologySpreadConstraints性能テスト | E-03 | ○ |
| C-09 | NFT-009: ボリュームアタッチメント性能テスト | E-04 | ○ |
| C-10 | NFT-010: DRAスケジューリング性能テスト | E-05 | ○ |
| C-11 | NFT-011: ServiceCIDR割り当て性能テスト | E-06 | ○ |
| C-12 | NFT-012: HPAスケーリング応答テスト | E-26 | ○ |
| C-13 | NFT-013: Cluster Autoscaler応答テスト | E-27 | ○ |
| C-14 | NFT-014: DNS自動スケーリングテスト | E-28 | ○ |
| C-15 | NFT-015: リーダー選出テスト | E-24 | ○ |
| C-16 | NFT-016: Pod自動再起動テスト | E-07, E-38 | ○ |
| C-17 | NFT-017: ノード障害時Pod再配置テスト | E-38 | ○ |
| C-18 | NFT-018: Liveness Probe障害検知テスト | E-21, E-22, E-23 | ○ |
| C-19 | NFT-019: Readiness Probe動作テスト | E-21, E-22 | ○ |
| C-20 | NFT-020: Startup Probe動作テスト | E-21, E-22, E-23 | ○ |
| C-21 | NFT-021: ChaosMonkey耐障害性テスト | E-09 | ○ |
| C-22 | NFT-022: Evictionリソース保護テスト | E-20 | ○ |
| C-23 | NFT-023: ResourceQuotaリソース制限テスト | E-25 | ○ |
| C-24 | NFT-024: LimitRangeコンテナリソース制約テスト | E-25 | ○ |
| C-25 | NFT-025: APIサーバーTLS通信テスト | E-19 | ○ |
| C-26 | NFT-026: ServiceAccountトークン認証テスト | E-10 | ○ |
| C-27 | NFT-027: X.509証明書認証テスト | E-11 | ○ |
| C-28 | NFT-028: RBAC認可テスト | E-18 | ○ |
| C-29 | NFT-029: ノード認証・認可テスト | E-12, E-13 | ○ |
| C-30 | NFT-030: SubjectAccessReview動作テスト | E-14 | ○ |
| C-31 | NFT-031: NetworkPolicy適用テスト | E-15 | ○ |
| C-32 | NFT-032: NetworkPolicy APIバリデーションテスト | E-16 | ○ |
| C-33 | NFT-033: AppArmorプロファイル適用テスト | E-17 | ○ |
| C-34 | NFT-034: PodSecurityAdmission適用テスト | E-40 | ○ |
| C-35 | NFT-035: APIレート制限テスト（429レスポンス） | E-19 | △ |
| C-36 | NFT-036: ローリングアップグレードテスト | E-29 | ○ |
| C-37 | NFT-037: APIバージョン後方互換性テスト | E-29 | ○ |
| C-38 | NFT-038: マルチプラットフォーム互換性テスト | E-39 | ○ |
| C-39 | NFT-039: クラウドプロバイダー互換性テスト | E-30 | ○ |
| C-40 | NFT-040: CSIドライバー互換性テスト | E-31 | ○ |
| C-41 | NFT-041: メトリクス収集テスト | E-32 | ○ |
| C-42 | NFT-042: イベント記録テスト | E-33 | ○ |
| C-43 | NFT-043: ロギング出力テスト | E-34 | ○ |
| C-44 | NFT-044: kubeadmクラスターデプロイテスト | E-35 | ○ |
| C-45 | NFT-045: クラスターバリデーションテスト | E-36 | ○ |
| C-46 | NFT-046: Conformanceテスト網羅性テスト | E-37 | ○ |
| C-47 | NFT-047: etcdストレステスト（許容レイテンシ） | E-43 | △ |
| C-48 | NFT-048: コントローラーマネージャー負荷テスト | E-38 | △ |
| C-49 | NFT-049: ExternalJWT認証テスト | E-41 | △ |
| C-50 | NFT-050: PodDisruptionBudget動作テスト | E-42 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-01（APIサーバーレイテンシ合格基準）**: p99 1秒以内という具体的な閾値はコードから直接導出できない。KubernetesのSLO文書やSIG-Scalabilityの定義を参照する必要がある。
  - 候補：Kubernetes SLO定義文書 / SIG-Scalability文書 / APIサーバーベンチマーク結果
- **C-06（大規模クラスター構成パラメータ）**: 5000ノード構成の具体値はperformance-configの最大ワークロードから外挿したもの。実環境での検証パラメータ確認が必要。
  - 候補：SIG-Scalabilityテスト結果 / kubemark設定 / CI/CDパイプライン設定
- **C-35（APIレート制限の具体値）**: レート制限の閾値や429レスポンスの動作はAPIサーバーのフラグ設定に依存する。コードではRateLimiter実装は確認できるが、具体的なデフォルト値の特定は追加調査が必要。
  - 候補：kube-apiserver起動フラグ文書 / APIサーバーのmax-requests-inflight設定
- **C-47（etcdストレステスト合格基準）**: etcdの許容レイテンシはデプロイ環境（ディスクI/O性能等）に大きく依存する。
  - 候補：etcd公式ドキュメント / Kubernetesインフラ要件文書
- **C-48（コントローラーマネージャー負荷テスト基準）**: キューバックログの規定値は明示的に定義されていない。
  - 候補：コントローラーマネージャーのメトリクス定義 / SIG-Apimachinery文書
- **C-49（ExternalJWT認証テスト詳細）**: stagingパッケージの実装が限定的で、テストケースの詳細条件の特定が不十分。
  - 候補：KEP文書 / SIG-Auth設計文書

## 5) リスクフラグ（レビュー観点）
- **リスク2（高リスク）**: 合格基準の具体値（C-01, C-06, C-47）はデプロイ環境やSLO要件に依存するため、プロジェクト固有の要件定義に基づく検証が必要
- **リスク1（中リスク）**: APIレート制限（C-35）やコントローラーマネージャー負荷テスト（C-48）の合格基準は、APIサーバーのフラグ設定やデプロイ構成に依存
- **リスク1（中リスク）**: ExternalJWT（C-49）は比較的新しい機能であり、実装の成熟度に応じてテストケースの見直しが必要
- **リスク0（低リスク）**: 認証・認可テスト（C-26〜C-30）、NetworkPolicyテスト（C-31, C-32）、Probeテスト（C-18〜C-20）はコードベースに明確な実装と既存テストが存在

## 6) レビュアーチェックリスト（最小）
- [ ] 合格基準の具体値（レイテンシ、スループット等）がプロジェクトのSLO要件と一致しているか確認
- [ ] 性能テスト（NFT-001〜NFT-014）のワークロード規模がターゲット環境に適しているか確認
- [ ] セキュリティテスト（NFT-025〜NFT-035）がプロジェクトのセキュリティポリシーを網羅しているか確認
- [ ] 可用性テスト（NFT-015〜NFT-024）のフェイルオーバー時間がSLAと整合しているか確認
- [ ] 互換性テスト（NFT-036〜NFT-040）の対象バージョン・プラットフォームが要件を満たしているか確認
- [ ] 保守性テスト（NFT-041〜NFT-046）のメトリクス項目が監視要件と一致しているか確認
- [ ] etcdストレステスト（NFT-047）の合格基準がインフラ仕様と整合しているか確認
