---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **稼働率・RTO・RPO目標値**：コード上に明示的な数値定義がなく、運用設計に依存
  2. **本番環境での推奨スループット値**：テスト値とデプロイスクリプト値が混在し、本番推奨値の確定が困難
  3. **PodSecurityContextの詳細設定値**：型定義は確認できるが具体的なデフォルト値の網羅が不十分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `cmd/kube-apiserver/app/options/options.go` - APIサーバーオプション定義
- E-02: `cmd/kube-apiserver/app/options/options_test.go` - APIサーバーオプションテスト（デフォルト値検証）
- E-03: `cmd/kube-apiserver/app/testing/testserver.go` - テストサーバー設定
- E-04: `staging/src/k8s.io/apiserver/pkg/storage/storagebackend/config.go` - ストレージバックエンド設定
- E-05: `pkg/cluster/ports/ports.go` - クラスタポート定義
- E-06: `cmd/kube-controller-manager/app/controllermanager.go` - コントローラマネージャ本体
- E-07: `cmd/kube-controller-manager/app/options/options_test.go` - コントローラマネージャオプションテスト
- E-08: `cmd/kube-controller-manager/app/core.go` - コアコントローラ定義
- E-09: `cmd/kube-controller-manager/app/apps.go` - アプリコントローラ定義
- E-10: `cmd/kube-scheduler/app/config/config.go` - スケジューラ設定
- E-11: `cmd/kube-scheduler/app/server_test.go` - スケジューラテスト（リーダー選出設定）
- E-12: `pkg/controller/nodelifecycle/node_lifecycle_controller.go` - ノードライフサイクルコントローラ
- E-13: `pkg/controller/nodelifecycle/node_lifecycle_controller_test.go` - ノードライフサイクルテスト
- E-14: `pkg/apis/flowcontrol/types.go` - FlowControl API型定義
- E-15: `pkg/apis/core/types.go` - コアAPI型定義（SecurityContext等）
- E-16: `cmd/kube-apiserver/app/options/completion.go` - WatchCache補完設定
- E-17: `pkg/kubeapiserver/default_storage_factory_builder.go` - デフォルトWatchCacheサイズ
- E-18: `cluster/gce/gci/configure-kubeapiserver.sh` - GCE環境APIサーバー設定
- E-19: `test/kubemark/resources/start-kubemark-master.sh` - Kubemark大規模テスト設定
- E-20: `staging/src/k8s.io/apiserver/pkg/server/config.go` - APIサーバー汎用設定
- E-21: `cmd/kube-controller-manager/app/batch.go` - バッチコントローラ設定
- E-22: `cmd/kube-controller-manager/app/storageversionmigrator.go` - ストレージバージョンマイグレーター
- E-23: `pkg/controller/nodeipam/ipam/timeout.go` - ノードIPAMタイムアウト制御
- E-24: `staging/src/k8s.io/apiserver/pkg/storage/storagebackend/factory/etcd3.go` - etcd3ストレージファクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API応答デフォルトRequestTimeoutは2分 | E-02 | ○ |
| C-02 | Kubelet HTTPタイムアウトは5秒 | E-01 | ○ |
| C-03 | etcdダイヤルタイムアウトは20秒 | E-03 | ○ |
| C-04 | etcdヘルスチェックタイムアウトは2秒 | E-04, E-24 | ○ |
| C-05 | etcdレディネスチェックタイムアウトは2秒 | E-04, E-24 | ○ |
| C-06 | MinRequestTimeoutは1800秒 | E-02 | ○ |
| C-07 | ストレージ初期化タイムアウトは1分 | E-02 | ○ |
| C-08 | MaxRequestsInFlightデフォルトは400 | E-02, E-20 | ○ |
| C-09 | 大規模クラスタでMaxRequestsInFlightは3000 | E-18, E-19 | ○ |
| C-10 | テスト用クライアントQPSは1000 | E-03 | ○ |
| C-11 | Controller Manager API QPSは50.0 | E-07 | ○ |
| C-12 | Namespaceコントローラ QPS 20倍引き上げ | E-08 | ○ |
| C-13 | 監査ログバッチスロットルQPSは49.5 | E-02 | ○ |
| C-14 | 並行コントローラ同期ワーカー数の設定存在 | E-09, E-21, E-08 | ○ |
| C-15 | 稼働率の数値目標 | **根拠なし** | △ |
| C-16 | RTO/RPOの数値目標 | **根拠なし** | △ |
| C-17 | リーダー選出機構の存在 | E-10, E-11 | ○ |
| C-18 | NodeMonitorGracePeriodは50秒（テスト値） | E-13 | ○ |
| C-19 | NodeMonitorPeriodは5秒（テスト値） | E-13 | ○ |
| C-20 | healthz/readyz/livezエンドポイントの提供 | E-05, E-12 | ○ |
| C-21 | ヘルスチェック用ポート番号の定義 | E-05 | ○ |
| C-22 | クライアント証明書認証のサポート | E-01, E-02 | ○ |
| C-23 | Webhook認証・認可のサポート | E-02 | ○ |
| C-24 | OIDC認証のサポート | E-02 | ○ |
| C-25 | RBAC認可のサポート | E-02 | ○ |
| C-26 | etcdとのTLS通信 | E-02 | ○ |
| C-27 | FlowSchemaによるAPI優先度制御 | E-14 | ○ |
| C-28 | MasterCountデフォルト1による水平スケール可能性 | E-01 | ○ |
| C-29 | WatchCache有効化とデフォルトサイズ100 | E-16, E-17 | ○ |
| C-30 | eventsリソースのWatchCacheサイズ0 | E-17 | ○ |
| C-31 | klogによる構造化ログ出力 | E-06 | ○ |
| C-32 | 監査ログの詳細設定パラメータ | E-02 | ○ |
| C-33 | コントローラのGraceful Shutdown制御 | E-06 | ○ |
| C-34 | PodSecurityContextの詳細デフォルト値 | **根拠なし** | △ |
| C-35 | 本番環境推奨スループット値の確定 | **根拠なし（テスト・スクリプト値のみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- **可用性の定量目標値（SLA/SLO）**: Kubernetesのソースコード上には稼働率やRTO/RPOの明示的な数値目標は定義されていない。これらは運用設計やSLA契約で別途定義されるべき項目である
  - 候補：SIG-architecture設計ドキュメント / Kubernetes SLOドキュメント / クラウドプロバイダSLA定義
- **PodSecurityContextのデフォルト値詳細**: 型定義は確認できるが、各フィールドのデフォルト値の完全な列挙はdefaults.goの網羅的解析が必要
  - 候補：`pkg/apis/core/v1/defaults.go` / Kubernetes公式ドキュメント
- **本番環境推奨スループット値**: テストコードとデプロイスクリプトからの値が混在しており、公式な本番推奨値はKubernetes公式ドキュメントを参照すべき
  - 候補：Kubernetes公式パフォーマンスSLI/SLOドキュメント / SIG-scalability推奨事項

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - テスト値と本番値の混在。テストコードから抽出した値（NodeMonitorGracePeriod等）が本番デフォルトと異なる可能性がある
- 1: 中リスク - 大規模クラスタ向け設定（max-requests-inflight=3000等）はGCEデプロイスクリプトからの抽出であり、他環境への適用性は要確認
- 0: 低リスク - セキュリティ関連の認証・認可方式はコードベースで十分に確認可能
- 2: 高リスク - 可用性の定量目標（SLA/SLO）がコード上に存在しないため、本ドキュメントだけでは可用性要件が不完全

## 6) レビュアーチェックリスト（最小）
- [ ] テスト値として記載された数値（NodeMonitorGracePeriod等）が本番デフォルト値と一致するか確認
- [ ] 大規模クラスタ向けスループット設定値が自組織の環境に適用可能か確認
- [ ] 可用性要件（SLA/SLO）を別途運用設計書で補完しているか確認
- [ ] セキュリティ要件が自組織のセキュリティポリシーと整合するか確認
- [ ] 監査ログ設定値がコンプライアンス要件を満たすか確認
- [ ] FlowControl（API Priority and Fairness）の設定がワークロード特性に合致するか確認
